#include "keys.h"
#include "keys.moc"

//Added by qt3to4:
#include <kconfig.h>
#include <kkeydialog.h>
#include <klocale.h>
#include <kactioncollection.h>

KeyData::KeyData(uint maxNb, uint nbActions, const ActionData *data,
                 QObject *parent)
    : QObject(parent), _maxNb(maxNb)
{
	_data.resize(nbActions);
	qCopy(data,data+nbActions,_data.begin());
    //_data.duplicate(data, nbActions);

    for (uint n=0; n<maxNb; n++)
        for (uint i=0; i<=n; i++)
            _keycodes[n][i].fill(0, nbActions);
}

void KeyData::setKeycodes(uint nb, uint index, const int *keycodes)
{
    Q_ASSERT( nb!=0 && nb-1<_maxNb && index<nb );
    for (uint n=nb-1; n<_maxNb; n++)
        for (int k=0; k<_data.size(); k++)
            if ( n==nb-1 || _keycodes[n][index][k]==0 )
                _keycodes[n][index][k] = keycodes[k];
}

void KeyData::setCurrentNb(uint nb)
{
    Q_ASSERT( nb<_maxNb );
    clear();
    _cols.fill(0, nb);
}

void KeyData::clear()
{
    for (int i=0; i<_cols.size(); i++)
        delete _cols[i];
    _cols.resize(0);
}

void KeyData::createActionCollection(int index, QWidget *receiver)
{
    Q_ASSERT( index<_cols.size() );
    _cols[index] = new KActionCollection(this);
    _cols[index]->setAssociatedWidget(receiver);
    for (int k=0; k<_data.size(); k++) {
        QString label = i18n(_data[k].label);
        QString name = QString("%2 %3").arg(index+1).arg(_data[k].name);
        const char *slot = (_data[k].slotRelease ? 0 : _data[k].slot);
        QAction *a = _cols[index]->addAction(name);
        a->setText(label);
        connect(a, SIGNAL(triggered(bool) ), receiver, slot);
        a->setShortcut(_keycodes[_cols.size()-1][index][k]);
        a->setEnabled(false);
        if ( slot==0 ) {
            SpecialData data;
            data.enabled = false;
            data.pressed = new Q3Signal(this);
            data.pressed->connect(receiver, _data[k].slot);
            data.released = new Q3Signal(this);
            data.released->connect(receiver, _data[k].slotRelease);
            _specActions[a] = data;
        }
    }
    KConfig config;
    config.setGroup(group());
    _cols[index]->readSettings(&config);
}

void KeyData::setEnabled(uint index, bool enabled)
{
    for (int k=0; k<_cols[index]->actions().count(); k++) {
        QMap<QAction *, SpecialData>::Iterator it =
            _specActions.find(_cols[index]->actions().value(k));
        if ( it==_specActions.end() )
            _cols[index]->actions().value(k)->setEnabled(enabled);
        else (*it).enabled = enabled;
    }
}

void KeyData::addKeys(KKeyDialog &d)
{
    for (int i=0; i<_cols.size(); i++)
        d.insert(_cols[i], i18n("Shortcuts for player #%1/%2", i+1,
                  _cols.size()));
}

void KeyData::save()
{
    for (int i=0; i<_cols.size(); i++)
    {
        KConfig config;
        config.setGroup(group());
        _cols[i]->writeSettings(&config);
    }
}

void KeyData::keyEvent(QKeyEvent *e, bool pressed)
{
    if ( e->isAutoRepeat() ) return;

    QMap<QAction *, SpecialData>::Iterator it = _specActions.begin();
    for(; it!=_specActions.end(); ++it) {
        if ( !it.value().enabled ) continue;
        if ( !it.key()->shortcuts().contains(e->key()) ) continue;
        if (pressed) it.value().pressed->activate();
        else it.value().released->activate();
    }
    e->ignore();
}
