/***************************************************************************
 *   Copyright (C) 2005 by Stefan Kebekus                                  *
 *   kebekus@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef PAGEINSERTIONWIDGET_H
#define PAGEINSERTIONWIDGET_H

#include <kcombobox.h>
#include <knuminput.h>
#include <kurlrequester.h>

#include "ui_pageInsertionWidget_base.h"
#include "pageNumber.h"


/** \brief widget used for page insertion

This widget allows the user to choose a file, and select a page after
or before which the file is inserted into the current document.

@author Stefan Kebekus
*/

class PageInsertionWidget_base : public QWidget, public Ui::PageInsertionWidget_base
{
public:
  PageInsertionWidget_base( QWidget *parent ) : QWidget( parent ) {
    setupUi( this );
  }
};


class PageInsertionWidget : public PageInsertionWidget_base
{
Q_OBJECT

public:
   /** constructor
    
   @params current number of the current page, to serve as a default
   value for the page selection widget

   @params numPages number of pages in the document, to serve as a
   maximum value for the page selection widget. This value MUST NOT be
   0.

   @params filename default filename of the file to be inserted, e.g.,
   "/home/user/test.djvu"

   @params filter filter used in the page selection dialog, e.g.,
   i18n("*.djvu|DjVu file (*.djvu)")

   @params parent parent widget, as usual

   */ 
   PageInsertionWidget(PageNumber current, PageNumber numPages, QString filename, QString filter, QWidget *parent = 0 );

   /** returns the name set in the file part of the widget */ 
   QString getFile() const {return fileWidget->url().pathOrUrl();}

   /** returns the page number where the file should be inserted

   This method returns the page number n where the file should be
   inserted where the file named in getFile() should be inserted. The
   return value satisfies 0 < n < numPages+1, where numPages is the
   number set in the constructor. It shall be interpreted as follows:

   For instance, if the user chooses "insert BEFORE page 1", this
   method would return '1'. If the uses chooses "insert AFTER page
   10", it would return 11.
   */
   PageNumber getPage() const {return pageNr->value()+QMAX(beforeAfter->currentIndex(),0);}

signals:
   void have_valid_file(bool);

private slots:
   /* Called when the text in the fileWidget changes. The method
      checks the validity of the filename, and emits the signal
      have_valid_file */
   void textChanged(const QString &);
};


#endif // PAGEINSERTIONTOWIDGET_H
