// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
/***************************************************************************
 *   Copyright (C) 2005 by Wilfried Huss                                   *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#include <config.h>

#include "exportDialog.h"

#include <kdebug.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>

#include <QCheckBox>

ExportDialog::ExportDialog(const QString& suggestedName, const QString& filter,
  QWidget* _parent, const QList<PageNumber>& _selectedPages, unsigned int _totalPages)
  : parent(_parent), selectedPages(_selectedPages), totalPages(_totalPages)
{
  checkbox = new QCheckBox(i18n("Export selected pages"), parent);

  if (selectedPages.isEmpty())
    checkbox->setEnabled(false);

  saveDialog = new KFileDialog(suggestedName, filter, parent, checkbox);
  saveDialog->setOperationMode(KFileDialog::Saving);
  saveDialog->show();

  connect(saveDialog, SIGNAL(okClicked()), this, SLOT(slotOk()));
}

ExportDialog::~ExportDialog()
{
  delete checkbox;
  checkbox = 0;
  delete saveDialog;
}

void ExportDialog::slotOk()
{
  QString fileName = saveDialog->selectedFile();
  bool exportSelected = checkbox->isChecked();

  if (fileName.isEmpty())
    return;

  QFileInfo finfo(fileName);
  if (finfo.exists())
  {
    int r = KMessageBox::warningContinueCancel (parent,
                i18n("The file %1\nexists. Do you want to overwrite that file?", fileName),
                i18n("Overwrite File"), KGuiItem(i18n("Overwrite")));

    if (r == KMessageBox::Cancel)
      return;
  }

  QList<PageNumber> exportedPages;

  if (exportSelected)
    exportedPages = selectedPages;
  else
    for (unsigned int i = 1; i <= totalPages; i++)
      exportedPages.append(i);
  
  emit exportPages(fileName, exportedPages);
}

#include "exportDialog.moc"
