// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
#ifndef history_h
#define history_h

// history.h
//
// (C) 2001 Stefan Kebekus
// Distributed under the GPL

#include "anchor.h"
#include "ligature_export.h"

#include "pageNumber.h"

#include <QList>
#include <QObject>


#define HISTORYLENGTH 10


class LIGATURECORE_EXPORT History : public QObject
{
  Q_OBJECT

public:
  void add(Anchor);
  void clear();

  Anchor* forward();
  Anchor* back();

signals:
  void backItem(bool);
  void forwardItem(bool);

private:
  // List of history items. First item is the oldest.
  QList<Anchor> historyList;

  QList<Anchor>::iterator currentItem;
};

#endif
