// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
/**
 * \file kvs_debug.h
 * Distributed under the GNU GPL version 2 or (at your option)
 * any later version. See accompanying file COPYING or copy at
 * http://www.gnu.org/copyleft/gpl.html
 *
 * \author Angus Leeming
 *
 * Trivial wrappers around the real debug stream objects
 * removing the need for those obnoxious magic numbers.
 */

#ifndef KVS_DEBUG_H
#define KVS_DEBUG_H

#include <kdebug.h>

// kvs == ligature
namespace kvs {

  enum Component {
    djvu = 1223,
    dvi = 4300,
    fax = 1223,
    pdf = 1223,
    ps = 1223,
    shell = 1223
  };

} // namespace kvs


inline kdbgstream kDebug(kvs::Component component)
  { return kDebug(int(component)); }

inline kdbgstream kWarning(kvs::Component component)
  { return kWarning(int(component)); }

inline kdbgstream kError(kvs::Component component)
  { return kError(int(component)); }


#endif
