// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
// pageSizeDialog.cpp
//
// Part of LIGATURE - A framework for multipage text/gfx viewers
//
// (C) 2002-2006 Stefan Kebekus
// Distributed under the GPL

#include <config.h>

#include "pageSizeDialog.h"
#include "pageSizeWidget.h"

#include <klocale.h>

#include <QSizePolicy>
#include <QToolTip>
#include <QWhatsThis>


pageSizeDialog::pageSizeDialog(QWidget* parent,
                               const char* name,
                               bool modal)
  : KDialog(parent),
    pageSizeW(new pageSizeWidget(this, "PageSizeWidget"))
{
  setCaption( i18n("Page Size") );
  setButtons( Ok|Apply|Cancel );
  setDefaultButton( Ok );
  setModal( true );

  QSizePolicy size_policy(QSizePolicy::Preferred, QSizePolicy::Preferred);
  size_policy.setHeightForWidth(pageSizeW->sizePolicy().hasHeightForWidth());
  pageSizeW->setSizePolicy(size_policy);
  setMainWidget(pageSizeW);
 
  QToolTip::add(pageSizeW, "<p>Choose a default page size that is used when no page size information can be found in the document.</p>" );
  QWhatsThis::add(pageSizeW, "<p><strong>Default Page Size</strong></p>"
                  "<p>Some documents do not specify the page size. It is then often hard for Ligature to determine if the document was "
                  "designed for, say, European 'A4' or U.S. 'Letter' paper. You can use this dialog to specify a default paper size that is "
                  "used when no information can be found in the document. For other documents, the setting made in this dialog will "
                  "not have any effect.</p>" );

  connect( this, SIGNAL( applyClicked() ), this, SLOT( slotApply() ) );
  connect( this, SIGNAL( okClicked() ), this, SLOT( slotApply() ) );
}


void pageSizeDialog::slotOk()
{
  if (!dataModel.isNull())
    dataModel->setUserPreferredPageSize(pageSizeW->pageSizeData());
  accept();
}


void pageSizeDialog::slotApply()
{
  if (!dataModel.isNull())
    dataModel->setUserPreferredPageSize(pageSizeW->pageSizeData());
}


void pageSizeDialog::setPageSize(const QString& name)
{
  if (pageSizeW == 0)
    return;
  pageSizeW->setPageSize(name);
}


#include "pageSizeDialog.moc"
