// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
/***************************************************************************
 *   Copyright (C) 2004 by Enrico Ros <eros.kde@email.it>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KPDF_PRESENTATIONWIDGET_H_
#define _KPDF_PRESENTATIONWIDGET_H_

#include "dataView.h"
#include "hyperlink.h"
#include "pagetransition.h"

#include <QDialog>
#include <QPixmap>
#include <QStringList>
#include <QTimer>
#include <QVector>

class RenderedDocumentPagePixmap;
class DocumentPageCache;
class PresentationFrame;
class QToolBar;

/**
 * @short A widget that shows pages as fullscreen slides (with transitions fx).
 *
 * This is a fullscreen widget that displays
 */
class PresentationWidget : public QDialog , public DataView
{
    Q_OBJECT
    public:
        PresentationWidget( QWidget * parent, DocumentPageCache* cache );
        ~PresentationWidget();

        virtual void setupObservers(DataModel*);

        void setup();
        bool canUnloadPixmap( int pageNumber );

    signals:
        void httpLink(const Hyperlink&);

    protected:
        // widget events
        void keyPressEvent( QKeyEvent * e );
        void wheelEvent( QWheelEvent * e );
        void mousePressEvent( QMouseEvent * e );
        void mouseMoveEvent( QMouseEvent * e );
        void paintEvent( QPaintEvent * e );

    private:
        void testCursorOnLink( int x, int y );
        void overlayClick( const QPoint & position );
        void changePage( int newPage );
        void generatePage();
        void generateIntroPage( QPainter & p );
        void generateContentsPage(RenderedDocumentPagePixmap* pageData, QPainter & p);
        void generateOverlay();
        void initTransition( const KPDFPageTransition *transition );
        const KPDFPageTransition defaultTransition() const;
        const KPDFPageTransition defaultTransition( int ) const;

        // cache stuff
        int m_width;
        int m_height;
        QPixmap m_lastRenderedPixmap;
        QPixmap m_lastRenderedOverlay;
        QRect m_overlayGeometry;
        Hyperlink hyperlink;
        bool m_handCursor;

        // transition related
        QTimer * m_transitionTimer;
        QTimer * m_overlayHideTimer;
        int m_transitionDelay;
        int m_transitionMul;
        QList< QRect > m_transitionRects;

        // misc stuff
        DocumentPageCache* m_cache;
        QVector< PresentationFrame * > m_frames;
        int m_frameIndex;
        QStringList m_metaStrings;
        QToolBar * m_topBar;

        double oldResolution;

        QTimer autoAdvanceTimer;

    private slots:
        void slotNextPage();
        void slotPrevPage();
        void slotFirstPage();
        void slotLastPage();
        void slotHideOverlay();
        void slotTransitionStep();

        void slotDelayedEvents();
};

#endif
