if (WIN32)

file(TO_CMAKE_PATH "$ENV{PROGRAMFILES}" _progFiles)

find_file(GNUWIN32_DIR gnuwin32 win32libs PATHS
   ${_progFiles}
   "C:/" "D:/" "E:/" "F:/" "G:/"
)

if (GNUWIN32_DIR)
   set(GNUWIN32_INCLUDE_DIR ${GNUWIN32_DIR}/include)
   set(GNUWIN32_LIBRARY_DIR ${GNUWIN32_DIR}/lib)
   set(GNUWIN32_BINARY_DIR  ${GNUWIN32_DIR}/bin)
   set(CMAKE_INCLUDE_PATH ${CMAKE_INCLUDE_PATH} ${GNUWIN32_INCLUDE_DIR})
   set(CMAKE_LIBRARY_PATH ${CMAKE_LIBRARY_PATH} ${GNUWIN32_LIBRARY_DIR})
   set(GNUWIN32_FOUND TRUE)
else (GNUWIN32_DIR)
   set(GNUWIN32_FOUND)
endif (GNUWIN32_DIR)

if (GNUWIN32_FOUND)
  if (NOT GNUWIN32_FIND_QUIETLY)
    message(STATUS "Found GNUWIN32: ${GNUWIN32_DIR}")
  endif (NOT GNUWIN32_FIND_QUIETLY)
else (GNUWIN32_FOUND)
  if (GNUWIN32_FIND_REQUIRED)
    message(SEND_ERROR "Could NOT find GNUWIN32")
  endif (GNUWIN32_FIND_REQUIRED)
endif (GNUWIN32_FOUND)

endif (WIN32)

