/* This file is part of the KDE libraries
    Copyright (C) 1997 Mark Donohoe (donohoe@kde.org)
              (C) 1997,1998, 2000 Sven Radej (radej@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <kdebug.h>
#include <kstatusbar.h>
#include <kconfig.h>
#include <kglobal.h>

#include <qframe.h>
#include <kconfiggroup.h>

KStatusBarLabel::KStatusBarLabel( const QString& text, int _id,
                                 KStatusBar *parent) :
  QLabel( parent )
{
  id = _id;

  setText( text );

  // umm... Mosfet? Can you help here?

  // Warning: QStatusBar draws shaded rectangle around every item - which
  // IMHO is stupid.
  // So NoFrame|Plain is the best you get. the problem is that only in case of
  // StyledPanel|Something you get QFrame to call QStyle::drawPanel().

  setLineWidth( 0 );
  setFrameStyle( QFrame::NoFrame );

  setAlignment( Qt::AlignHCenter | Qt::AlignVCenter );

  connect (this, SIGNAL(itemPressed(int)), parent, SIGNAL(pressed(int)));
  connect (this, SIGNAL(itemReleased(int)), parent, SIGNAL(released(int)));
}

void KStatusBarLabel::mousePressEvent (QMouseEvent *)
{
  emit itemPressed (id);
}

void KStatusBarLabel::mouseReleaseEvent (QMouseEvent *)
{
  emit itemReleased (id);
}

KStatusBar::KStatusBar( QWidget *parent )
  : QStatusBar( parent )
{
    // make the size grip stuff configurable
    // ...but off by default (sven)
    KSharedConfig::Ptr config = KGlobal::config();

  KConfigGroup group( config, QLatin1String("StatusBar style") );
  bool grip_enabled = group.readEntry(QLatin1String("SizeGripEnabled"), false);
  setSizeGripEnabled(grip_enabled);
}

KStatusBar::~KStatusBar ()
{
}

void KStatusBar::insertItem( const QString& text, int id, int stretch)
{
  if (items[id])
    kDebug() << "KStatusBar::insertItem: item id " << id << " already exists." << endl;

  KStatusBarLabel *l = new KStatusBarLabel (text, id, this);
  l->setFixedHeight(fontMetrics().height()+2);
  items.insert(id, l);
  addWidget (l, stretch);
  l->show();
}

void KStatusBar::insertPermanentItem( const QString& text, int id, int stretch)
{
  if (items[id])
    kDebug() << "KStatusBar::insertItem: item id " << id << " already exists." << endl;

  KStatusBarLabel *l = new KStatusBarLabel (text, id, this);
  l->setFixedHeight(fontMetrics().height()+2);
  items.insert(id, l);
  addPermanentWidget (l, stretch);
  l->show();
}

void KStatusBar::removeItem (int id)
{
  KStatusBarLabel *l = items[id];
  if (l)
  {
    removeWidget (l);
    items.remove(id);
    delete l;
  }
  else
    kDebug() << "KStatusBar::removeItem: bad item id: " << id << endl;
}

bool KStatusBar::hasItem( int id ) const
{
  KStatusBarLabel *l = items[id];
  if (l)
    return true;
  else
    return false;
}

void KStatusBar::changeItem( const QString& text, int id )
{
  KStatusBarLabel *l = items[id];
  if (l)
  {
    l->setText(text);
    if(l->minimumWidth () != l->maximumWidth ())
    {
      reformat();
    }
  }
  else
    kDebug() << "KStatusBar::changeItem: bad item id: " << id << endl;
}

void KStatusBar::setItemAlignment (int id, Qt::Alignment alignment)
{
  KStatusBarLabel *l = items[id];
  if (l)
  {
    l->setAlignment(alignment);
  }
  else
    kDebug() << "KStatusBar::setItemAlignment: bad item id: " << id << endl;
}

void KStatusBar::setItemFixed(int id, int w)
{
  KStatusBarLabel *l = items[id];
  if (l)
  {
    if (w==-1)
      w=fontMetrics().boundingRect(l->text()).width()+3;

    l->setFixedWidth(w);
  }
  else
    kDebug() << "KStatusBar::setItemFixed: bad item id: " << id << endl;
}

#include "kstatusbar.moc"

//Eh!!!
//Eh what ? :)

