/* This file is part of the KDE libraries
   Copyright (C) 2000 Matej Koss <koss@miesto.sk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include <qevent.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <QStackedWidget>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qprogressbar.h>

#include <kapplication.h>
#include <klocale.h>
#include <kdebug.h>

#include "jobclasses.h"
#include "statusbarprogress.h"

namespace KIO {

StatusbarProgress::StatusbarProgress( QWidget* parent, bool button )
  : ProgressBase( parent ) {

  m_bShowButton = button;

  // only clean this dialog
  setOnlyClean(true);
  // TODO : is this really needed ?
  setStopOnClose(false);

  int w = fontMetrics().width( " 999.9 kB/s 00:00:01 " ) + 8;
  box = new QHBoxLayout( this);
  box->setMargin(0);
  box->setSpacing(0);

  m_pButton = new QPushButton( "X", this );
  box->addWidget( m_pButton  );
  stack = new QStackedWidget( this );
  box->addWidget( stack );
  connect( m_pButton, SIGNAL( clicked() ), this, SLOT( slotStop() ) );

  m_pProgressBar = new QProgressBar( this );
//   m_pProgressBar->setFrameStyle( QFrame::Box | QFrame::Raised );
//   m_pProgressBar->setLineWidth( 1 );
  m_pProgressBar->setBackgroundRole( QPalette::Window ); // ### KDE4: still needed?
  m_pProgressBar->installEventFilter( this );
  m_pProgressBar->setMinimumWidth( w );
  stack->insertWidget( 1,m_pProgressBar );

  m_pLabel = new QLabel( "", this );
  m_pLabel->setAlignment( Qt::AlignHCenter | Qt::AlignVCenter );
  m_pLabel->installEventFilter( this );
  m_pLabel->setMinimumWidth( w );
  stack->insertWidget( 2,m_pLabel);
  setMinimumSize( sizeHint() );

  mode = None;
  setMode();
}


void StatusbarProgress::setJob( KIO::Job *job )
{
  ProgressBase::setJob( job );

  mode = Progress;
  setMode();
}


void StatusbarProgress::setMode() {
  switch ( mode ) {
  case None:
    if ( m_bShowButton ) {
      m_pButton->hide();
    }
    stack->hide();
    break;

  case Label:
    if ( m_bShowButton ) {
      m_pButton->show();
    }
    stack->show();
    stack->setCurrentWidget( m_pLabel );
    break;

  case Progress:
    if ( m_bShowButton ) {
      m_pButton->show();
    }
    stack->show();
    stack->setCurrentWidget( m_pProgressBar );
    break;
  }
}


void StatusbarProgress::slotClean() {
  // we don't want to delete this widget, only clean
  m_pProgressBar->setValue( 0 );
  m_pLabel->clear();

  mode = None;
  setMode();
}


void StatusbarProgress::slotTotalSize( KJob*, qulonglong size ) {
  m_iTotalSize = size;  // size is measured in bytes
}

void StatusbarProgress::slotPercent( KJob*, unsigned long percent ) {
  m_pProgressBar->setValue( percent );
}


void StatusbarProgress::slotSpeed( KJob*, unsigned long speed ) {
  if ( speed == 0 ) { // spped is measured in bytes-per-second
    m_pLabel->setText( i18n( " Stalled ") );
  } else {
    m_pLabel->setText( i18n( " %1/s ",  KIO::convertSize( speed )) );
  }
}


bool StatusbarProgress::eventFilter( QObject *, QEvent *ev ) {
  if ( ! m_pJob ) { // don't react when there isn't any job doing IO
    return true;
  }

  if ( ev->type() == QEvent::MouseButtonPress ) {
    QMouseEvent *e = (QMouseEvent*)ev;

    if ( e->button() == Qt::LeftButton ) {    // toggle view on left mouse button
      if ( mode == Label ) {
	mode = Progress;
      } else if ( mode == Progress ) {
	mode = Label;
      }
      setMode();
      return true;

    }
  }

  return false;
}

} /* namespace */
#include "statusbarprogress.moc"
