# Look for NMM

# Copyright (c) 2006, Matthias Kretz, <kretz@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.



FIND_PATH (NMM_DEFAULT_PREFIX_INC nmm/base/ProxyObject.hpp /usr/include /usr/local/include)
GET_FILENAME_COMPONENT(NMM_DEFAULT_PREFIX "${NMM_DEFAULT_PREFIX_INC}/" PATH)
SET(NMM_PREFIX ${NMM_DEFAULT_PREFIX} CACHE PATH "The prefix of the NMM installation to use")

FIND_PATH (NMM_INCLUDE_DIR nmm/base/ProxyObject.hpp ${NMM_PREFIX}/include)
FIND_LIBRARY (NMM_LIBRARY_BASE      NAMES nmmbase      PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_GRAPHMGR  NAMES nmmgraphmgr  PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_UTILS     NAMES nmmutils     PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_REGISTRY  NAMES nmmregistry  PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_SERIALIZE NAMES nmmserialize PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_ISYNC     NAMES nmmisync     PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_SYNC      NAMES nmmsync      PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_FORMAT    NAMES nmmformat    PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_IFILE     NAMES nmmifile     PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_IGENERAL  NAMES nmmigeneral  PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_IDEVICE   NAMES nmmidevice   PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_IBASE     NAMES nmmibase     PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_IPROGRESS NAMES nmmiprogress PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_IAUDIODEVICE NAMES nmmiaudiodevice PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)
FIND_LIBRARY (NMM_LIBRARY_MEMORYNMG NAMES nmmmemorymgr  PATHS ${NMM_PREFIX}/lib/nmm ${NMM_PREFIX}/lib)

IF (NMM_INCLUDE_DIR AND NMM_LIBRARY_BASE AND NMM_LIBRARY_GRAPHMGR AND
        NMM_LIBRARY_UTILS AND NMM_LIBRARY_REGISTRY AND NMM_LIBRARY_SERIALIZE AND
        NMM_LIBRARY_ISYNC AND NMM_LIBRARY_SYNC AND NMM_LIBRARY_FORMAT AND NMM_LIBRARY_IFILE AND
        NMM_LIBRARY_IGENERAL AND NMM_LIBRARY_IPROGRESS AND NMM_LIBRARY_IAUDIODEVICE 
        AND NMM_LIBRARY_IDEVICE)
  SET (NMM_FOUND TRUE)
ELSE (NMM_INCLUDE_DIR AND NMM_LIBRARY_BASE AND NMM_LIBRARY_GRAPHMGR AND
        NMM_LIBRARY_UTILS AND NMM_LIBRARY_REGISTRY AND NMM_LIBRARY_SERIALIZE AND
        NMM_LIBRARY_ISYNC AND NMM_LIBRARY_SYNC AND NMM_LIBRARY_FORMAT AND NMM_LIBRARY_IFILE AND
        NMM_LIBRARY_IGENERAL AND NMM_LIBRARY_IPROGRESS AND NMM_LIBRARY_IAUDIODEVICE 
        AND NMM_LIBRARY_IDEVICE)
  SET (NMM_FOUND FALSE)
ENDIF (NMM_INCLUDE_DIR AND NMM_LIBRARY_BASE AND NMM_LIBRARY_GRAPHMGR AND
        NMM_LIBRARY_UTILS AND NMM_LIBRARY_REGISTRY AND NMM_LIBRARY_SERIALIZE AND
        NMM_LIBRARY_ISYNC AND NMM_LIBRARY_SYNC AND NMM_LIBRARY_FORMAT AND NMM_LIBRARY_IFILE AND
        NMM_LIBRARY_IGENERAL AND NMM_LIBRARY_IPROGRESS AND NMM_LIBRARY_IAUDIODEVICE 
        AND NMM_LIBRARY_IDEVICE)

IF (NMM_FOUND)
  MESSAGE(STATUS "NMM found in <${NMM_PREFIX}>")
  SET (NMM_LIBS ${NMM_LIBRARY_BASE} ${NMM_LIBRARY_GRAPHMGR} ${NMM_LIBRARY_UTILS}
      ${NMM_LIBRARY_REGISTRY} ${NMM_LIBRARY_SERIALIZE} ${NMM_LIBRARY_ISYNC}
      ${NMM_LIBRARY_SYNC} ${NMM_LIBRARY_FORMAT} ${NMM_LIBRARY_IFILE} ${NMM_LIBRARY_IGENERAL}
      ${NMM_LIBRARY_IBASE} ${NMM_LIBRARY_IAUDIODEVICE} ${NMM_LIBRARY_MEMORYNMG} 
      ${NMM_LIBRARY_IDEVICE} ${NMM_LIBRARY_IPROGRESS} )
ELSE (NMM_FOUND)
  MESSAGE(STATUS "Could not find NMM, the Phonon-NMM backend will not be compiled.")
ENDIF (NMM_FOUND)

MARK_AS_ADVANCED (NMM_INCLUDE_DIR NMM_LIBRARY_BASE NMM_LIBRARY_GRAPHMGR
    NMM_LIBRARY_UTILS NMM_LIBRARY_REGISTRY NMM_LIBRARY_SERIALIZE
    NMM_LIBRARY_ISYNC NMM_LIBRARY_SYNC NMM_LIBRARY_FORMAT NMM_LIBRARY_IFILE NMM_LIBRARY_IGENERAL
    NMM_DEFAULT_PREFIX_INC NMM_LIBRARY_IBASE NMM_LIBRARY_IAUDIODEVICE NMM_LIBRARY_MEMORYNMG 
    NMM_LIBRARY_IDEVICE NMM_LIBRARY_IPROGRESS)
