# Option for build or not Theora

# Copyright (c) 2006, Laurent Montel, <montel@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


if(THEORA_INCLUDE_DIR AND THEORA_LIBRARY)
	# Already in cache, be silent
	set(THEORA_FIND_QUIETLY TRUE)	
endif(THEORA_INCLUDE_DIR AND THEORA_LIBRARY)

set(THEORA_LIBRARY)
set(THEORA_INCLUDE_DIR)

FIND_PATH(THEORA_INCLUDE_DIR theora/theora.h
	/usr/include
	/usr/local/include
)

FIND_LIBRARY(THEORA_OGG_LIBRARIES NAMES ogg
	PATHS
	/usr/lib
	/usr/local/lib
)

FIND_LIBRARY(THEORA_VORBIS_LIBRARIES NAMES vorbis
	PATHS
	/usr/lib
	/usr/local/lib
)
FIND_LIBRARY(THEORA_LIB_LIBRARIES NAMES theora
	PATHS
	/usr/lib
	/usr/local/lib
)

if(THEORA_LIB_LIBRARIES AND THEORA_VORBIS_LIBRARIES AND THEORA_OGG_LIBRARIES)
	set(THEORA_LIBRARY ${THEORA_LIB_LIBRARIES} ${THEORA_OGG_LIBRARIES} ${THEORA_VORBIS_LIBRARIES})
endif(THEORA_LIB_LIBRARIES AND THEORA_VORBIS_LIBRARIES AND THEORA_OGG_LIBRARIES)

if(THEORA_INCLUDE_DIR AND THEORA_LIBRARY)
   MESSAGE( STATUS "theora found: includes in ${THEORA_INCLUDE_DIR}, library in ${THEORA_LIBRARY}")
   set(THEORA_FOUND TRUE)
else(THEORA_INCLUDE_DIR AND THEORA_LIBRARY)
   MESSAGE( STATUS "theora not found")
endif(THEORA_INCLUDE_DIR AND THEORA_LIBRARY)

MARK_AS_ADVANCED(THEORA_INCLUDE_DIR THEORA_LIBRARY)

