/* This file is part of Noatun

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>
  Copyright 2006 by Charles Samuels <charles@kde.org>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef N_PREFERENCESDIALOG_H
#define N_PREFERENCESDIALOG_H

#include <noatun_export.h>

#include <kpagedialog.h>

namespace Noatun
{
class Global;
class PreferencesPage;
class Plugin;

class PreferencesDialogPrivate;

/**
 * @brief Noatun preferences dialog
 * @author Stefan Gehn \<metz AT gehn DOT net\>
 *
 * @todo current page order is defined by plugin loading order. Either make the
 *       widget sort pages alphabetically or organize in logical groups
 *       (application settings, plugin settings)
 **/
class NOATUN_EXPORT PreferencesDialog : public KPageDialog
{
Q_OBJECT

public:
	explicit PreferencesDialog(Global *nInstance);
	~PreferencesDialog();

	/**
	 * @brief Add @p page to the preferences dialog
	 **/
	void addPreferencesPage(PreferencesPage *page);
	/**
	 * @brief Remove @p page from the preferences dialog
	 **/
	void removePreferencesPage(PreferencesPage *page);

public Q_SLOTS:
	/**
	 * @brief Open the preferences dialog
	 **/
	void show();
	/**
	 * @brief Open the preferences dialog with @p page as active preferences page
	 **/
	void show(PreferencesPage *page);

private Q_SLOTS:
	void saveDirtyPages();
	void setDefaults();
	//void addPluginPage(Plugin *p);
	//void removePluginPage(Plugin *p);
	void updateDirtyPages(bool isChanged);

private:
	PreferencesDialogPrivate * const d;
};

} // namespace Noatun
#endif // N_PREFERENCESDIALOG_H
