#ifndef KJVIS_H
#define KJVIS_H

#include "kjwidget.h"
//#include <noatun/visualization.h>
#include "kjconfig.h"

class KJMainWindow;
class KPixmap;

class KJVisScope : public KJWidget
{
	public:
		KJVisScope(KJMainWindow *parent) : KJWidget(parent) {};
		void swapScope(int newOne);
};


// dummy-scope displaying nothing
class KJNullScope : public KJVisScope
{
	public:
		KJNullScope(const QStringList &, KJMainWindow *parent);
		virtual void paint(QPainter *p, const QRect &);
		virtual bool mousePress(const QPoint&);
		virtual void mouseRelease(const QPoint &, bool in);
		virtual void readConfig(void);
	private:
		KPixmap *mBack;
};

#if 0

// analyzer-like scope
class KJFFT : public KJVisScope, public MonoFFTScope
{
	public:
		KJFFT(const QStringList &, KJMainWindow *parent);
		virtual void paint(QPainter *p, const QRect &);
		virtual void scopeEvent(float *d, int size);

		virtual bool mousePress(const QPoint&);
		virtual void mouseRelease(const QPoint &, bool in);
		virtual void readConfig(void);

	private:
		QColor mColor;
		KPixmap *mGradient;
		KPixmap *mBack;
		KPixmap *mAnalyzer;
		int mMultiples;
		int mTimerValue;
};


// analyzer-like scope, stereo version
class KJStereoFFT : public KJVisScope, public StereoFFTScope
{
	public:
		KJStereoFFT(const QStringList &, KJMainWindow *parent);
		virtual void paint(QPainter *p, const QRect &);
		virtual void scopeEvent(float *left, float *right, int len);

		virtual bool mousePress(const QPoint&);
		virtual void mouseRelease(const QPoint &, bool in);
		virtual void readConfig(void);

	private:
		QColor mColor;
		KPixmap *mGradient;
		KPixmap *mBack;
		KPixmap *mAnalyzer;
		int mMultiples;
		int mTimerValue;
};


// oscilloscope showing waveform
class KJScope : public KJVisScope, public MonoScope
{
	public:
		KJScope ( const QStringList &, KJMainWindow *parent);
		virtual void paint(QPainter *p, const QRect &);
		virtual void scopeEvent(float *d, int size);

		virtual bool mousePress(const QPoint&);
		virtual void mouseRelease(const QPoint &, bool in);
		virtual void readConfig(void);

	private:
		QColor mColor;
		KPixmap *mGradient;
		KPixmap *mBack;
		KPixmap *mOsci;
		int mMultiples;
		int mWidth;
		int mHeight;
		unsigned int blurnum;
		int mTimerValue;
};

#endif

#endif
