#ifndef NID3_H
#define NID3_H

#include <config.h>

#include "noatun/playlist.h"
#include "noatun/plugin.h"
#include "noatuntags/tags.h"

#include <qobject.h>
#include <qthread.h>
#include <qmutex.h>

#ifdef HAVE_TAGLIB
#include <tstring.h>
#endif


class KFileMetaInfo;
class KAction;
class KComponentData;

class MetaTagLoader : public Noatun::Plugin, public Noatun::Tags
{
	friend class ReaderThread;

	Q_OBJECT
	public:
		MetaTagLoader(const KComponentData &instance, Noatun::Global *parent, const char* name);
		~MetaTagLoader();

		Noatun::Interface *getInterface(const QString &name);
	public Q_SLOTS:
		bool update(Noatun::PlaylistItem & item);
		void editTag();
		void slotNewCurrent();

	protected:
		virtual void customEvent(QCustomEvent *);

	protected:
		QMutex mListMutex;
		QValueList<Noatun::PlaylistItem> mList;

	private:
		bool storeProperty(Noatun:: PlaylistItem &item, const QString &key, const QString &value);

	private:
		KAction *mAction;
		QThread *mThread;
		Noatun::PropertyMap propMap;
};



class TagBundle
{
	public:
		QString title, artist, album, comment, genre, trackno, year;
		QString bitrate, samplerate, channels;
		int length;
};


class TagEvent : public QCustomEvent
{
	public:
		TagEvent(Noatun::PlaylistItem item, TagBundle tag) : QCustomEvent(QEvent::User + 1), _tag(tag), _item(item) {}
		TagBundle tag() const { return _tag; }
		Noatun::PlaylistItem item() const { return _item; }
	private:
		TagBundle _tag;
		Noatun::PlaylistItem _item;
};



class ReaderThread : public QThread
{
	public:
		ReaderThread(MetaTagLoader *loader);
		virtual void run();

	private:
		void readTag(Noatun::PlaylistItem &item);
#ifdef HAVE_TAGLIB
		QString convertTString(const TagLib::String s, bool stripWhiteSpace);
		QString convertInt(int val);
#endif
		QString getProperty(KFileMetaInfo &info, const QString &key);

	private:
		MetaTagLoader *mLoader;
};


#endif
