/* This file is part of Noatun

  This file was created on 2007-02-01

  Copyright 2007 by Stefan Gehn <mETz81@web.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/
#ifndef N_PHONON_H
#define N_PHONON_H

#include <noatun/plugin.h>
#include <noatun/plugininterfaces.h>

#include <phonon/phononnamespace.h> // for Phonon::State

using namespace Noatun;

namespace Phonon
{
  class MediaObject;
  class AudioPath;
  //class VideoPath;
  class AudioOutput;
  //class VideoWidget;
}

class PhononPlugin : public Plugin, public EngineInterface
{
Q_OBJECT
public:
	PhononPlugin(const KComponentData &instance, Global *nInst, const char* name);
	virtual ~PhononPlugin();

	virtual void init();
	virtual void requestUnload();
	Interface *getInterface(const QString &interface);

	virtual Player::State state() const;
	virtual int position() const;
	virtual int length() const;
	virtual QStringList mimeTypes() const;
	virtual unsigned int softwareVolume() const;
	virtual void setSoftwareVolume(unsigned int percent);
	virtual bool play(const KUrl &url);
	virtual void pause();
	virtual void stop();
	virtual void setPosition(int msec);

private Q_SLOTS:
	void updateState(Phonon::State oldState, Phonon::State newState);
	void finishedPlaying();

private:
	static Player::State convertState(Phonon::State s);

private:
	Phonon::MediaObject *mMediaObject;
	Phonon::AudioPath   *mAudioPath;
	//Phonon::VideoPath   *mVideoPath;
	Phonon::AudioOutput *mAudioOutput;
	//Phonon::VideoWidget *mVideoWidget;
};

#endif // N_PHONON_H
