/***************************************************************************
                     A simple database-driven playlist for Noatun
                    ---------------------------------------------
    begin                : 24.05.2005
    copyright            : (C) 2005 by Stefan Gehn
    email                : Stefan Gehn <mETz81@web.de>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SIMPLEPLAYLIST_H
#define SIMPLEPLAYLIST_H

#include <noatun/plugin.h>
#include <noatun/plugininterfaces.h>
#include <noatun/playlist.h>

#include <kurl.h>

#include "simpledb.h"

class KComponentData;
class KMainWindow;

class SimpleMainWindow;
class SimpleItemSource;
class SimpleListView;
class SimpleDB;
class ItemAdder;
class SimplePlaylistItem;

class SimplePlaylist: public Noatun::Plugin, public Noatun::PlaylistInterface, public Noatun::ItemSourceInterface
{
	Q_OBJECT
friend class SimplePlaylistItem;
public:
	SimplePlaylist(const KComponentData &inst, Noatun::Global *global, const char* name);
	~SimplePlaylist();

	virtual void init();
	virtual void requestUnload();

	virtual KMainWindow *mainWindow() const;
	Noatun::Interface *getInterface(const QString &name); // from Plugin

	virtual void addFile(const KURL &file, bool purgeList, bool autoplay); // from PlaylistInterface
	virtual Noatun::PlaylistItem getFirst() const; // from PlaylistInterface
	virtual Noatun::PlaylistItem getAfter(const Noatun::PlaylistItem &item) const; // from PlaylistInterface

	virtual Noatun::PlaylistItem forward(); // from ItemSourceInterface
	virtual Noatun::PlaylistItem backward(); // from ItemSourceInterface
	virtual void setCurrent(const Noatun::PlaylistItem &item); // from ItemSourceInterface

	SimplePlaylistItem *getById(int id) const;

	/// Used to add ONE file to the playlist
	void addSingleFile(const KURL &url, int afterId, bool autoplay);

	/// Used to add a list of files to the playlist
	void addFiles(const KURL::List &urls, int afterId, bool autoplay);

	/// @internal, used for adding prepared data into the playlist
	int addFile(const KURL &url, int length, const Noatun::PropertyMap &properties, int afterId);

	SimpleDB *db();

protected:
	void itemCreated(SimplePlaylistItem *item); // called by SimplePlaylistItem
	void itemDestroyed(SimplePlaylistItem *item); // called by SimplePlaylistItem

public Q_SLOTS:
	void purgeList();
	void debugDbMap();

private Q_SLOTS:
	void slotPlayItem(int id);
	void slotItemAdderFinished();

private:
	SimpleMainWindow *mWin;
	SimpleDB *mDb;
	QMap <int, SimplePlaylistItem*> mDbMap;
	ItemAdder *mItemAdder;
};


class SimplePlaylistItem: public Noatun::PlaylistItemData
{
public:
	/// Adds a playlistitem to the db
	SimplePlaylistItem(SimplePlaylist *pl, const KURL &url, int length,
		const Noatun::PropertyMap &props, int insertAfterId = -1);
	/// Fetches its data from the db
	SimplePlaylistItem(SimplePlaylist *pl, int id);
	virtual ~SimplePlaylistItem();

	virtual QString property(const QString &key, const QString &def) const;
	virtual void setProperty(const QString &key, const QString &val);
	virtual void setProperties(const Noatun::PropertyMap &properties);
	virtual void clearProperty(const QString &key);
	virtual QStringList properties() const;
	virtual bool hasProperty(const QString &key) const;
	virtual KURL url() const;
	virtual void setUrl(const KURL &url);
	virtual int length() const;
	virtual void setLength(int ms);
	virtual void remove();

	int id() const;

private:
	DBItem mItem;
	bool bRemoved;
	SimplePlaylist *playlist;
}; // END class SimplePlaylistItem


#endif
