/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef PHONON_GSTREAMER_AUDIOPATH_H
#define PHONON_GSTREAMER_AUDIOPATH_H

#include <QList>
#include <QObject>

#include "pipeline.h"
#include "qbtgstreamer/qbtgstreamerbin.h"
#include "qbtgstreamer/qbtgstreamerelement.h"
#include "qbtgstreamer/qbtgstreamerpad.h"
#include "qbtgstreamer/qbtgstreamerghostpad.h"

namespace Phonon
{
namespace GStreamer
{
    class AudioEffect;
    class AbstractAudioOutput;

    struct OutputLink
    {
        AbstractAudioOutput *output;
        QbtGStreamerGhostPad *srcPad;
        QbtGStreamerGhostPad *sinkPad;
    };
 
    class AudioPathPrivate
    {
        public:
            AudioPathPrivate()
                : pipeline(0),
                  bin(0),
                  adder(0),
                  adderSrc(0),
                  tee(0),
                  teeSink(0)
            {
            }

            Pipeline *pipeline;
            QbtGStreamerBin *bin;
            QbtGStreamerElement *adder;
            QbtGStreamerPad *adderSrc;
            QbtGStreamerElement *tee;
            QbtGStreamerPad *teeSink;

            QList<OutputLink *> links;

            bool setupBin();
            QbtGStreamerGhostPad *requestSrcPad();
            void releaseSrcPad(QbtGStreamerGhostPad *pad);
    };

    class AudioPath : public QObject
    {
        Q_OBJECT

        friend class AudioPathPrivate;

        public:
            AudioPath(QObject *parent);
            ~AudioPath();

            Q_INVOKABLE bool addOutput(QObject *audioOutput);
            Q_INVOKABLE bool removeOutput(QObject *audioOutput);
            Q_INVOKABLE bool insertEffect(QObject *newEffect, QObject *insertBefore = 0);
            Q_INVOKABLE bool removeEffect(QObject *effect);

        private:
            QList<AudioEffect *> m_effects;
            QList<AbstractAudioOutput *> m_outputs;
            
            AudioPathPrivate *d;
    };
}} //namespace Phonon::GStreamer

// vim: sw=4 ts=4 tw=80 noet
#endif // PHONON_GSTREAMER_AUDIOPATH_H
