/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERBUS
#define QBTGSTREAMERBUS

#include <QString>

#include "qbtgstreamerobject.h"
#include "qbtgstreamermessage.h"
#include "qbtgstreamerdatapointer.h"
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

class QbtGStreamerBusPrivate
{
public:
    QbtGStreamerBusPrivate()
        : bus(0)
    {
    }

    static void bus_message(GstBus *bus, GstMessage *message, gpointer user_data);

    GstBus *bus;
};

class QBTGSTREAMER_EXPORT QbtGStreamerBus : public QbtGStreamerObject
{
Q_OBJECT

    friend class QbtGStreamerBusPrivate;

public:
    /*GstBus* gst_bus_new(void);*/
    QbtGStreamerBus();

    /*gboolean gst_bus_post(GstBus *bus, GstMessage *message);*/
    bool postMessage(QbtGStreamerMessage *message);

    /*gboolean gst_bus_have_pending(GstBus *bus);*/
    bool pendingMessages();

    /*GstMessage* gst_bus_peek(GstBus *bus);*/
    QbtGStreamerMessage *peek();

    /*GstMessage* gst_bus_pop(GstBus *bus);*/
    QbtGStreamerMessage *pop();

    /*void gst_bus_set_flushing(GstBus *bus, gboolean flushing);*/
    void setFlushing(bool flushing);

    /*void gst_bus_add_signal_watch(GstBus *bus);
      void gst_bus_remove_signal_watch(GstBus *bus);*/
    void messageWatch(bool watch);

    /*void gst_bus_enable_sync_message_emission(GstBus *bus);
      void gst_bus_disable_sync_message_emission(GstBus *bus);*/
    void syncMessageWatch(bool watch);

    /*void gst_bus_add_signal_watch_full(GstBus *bus, gint priority);*/
    void messageWatchPriority(bool watch, int priority);

    void setGstBus(GstBus *bus);
    GstBus *gstBus();

signals:
    void message(QbtGStreamerMessage *message, QbtGStreamerDataPointer *data);

private:
    static QbtGStreamerBus* m_instance;

    QbtGStreamerBusPrivate *d;
};

#if 0
These are functions that still need to be added or checked!
-----------------------------------------------------------

enum        GstBusFlags;
enum        GstBusSyncReply;
gboolean    (*GstBusFunc)                   (GstBus *bus,
                                             GstMessage *message,
                                             gpointer data);
GstBusSyncReply (*GstBusSyncHandler)        (GstBus *bus,
                                             GstMessage *message,
                                             gpointer data);

void        gst_bus_set_sync_handler        (GstBus *bus,
                                             GstBusSyncHandler func,
                                             gpointer data);
GstBusSyncReply gst_bus_sync_signal_handler (GstBus *bus,
                                             GstMessage *message,
                                             gpointer data);
GSource*    gst_bus_create_watch            (GstBus *bus);
guint       gst_bus_add_watch_full          (GstBus *bus,
                                             gint priority,
                                             GstBusFunc func,
                                             gpointer user_data,
                                             GDestroyNotify notify);
guint       gst_bus_add_watch               (GstBus *bus,
                                             GstBusFunc func,
                                             gpointer user_data);


gboolean    gst_bus_async_signal_func       (GstBus *bus,
                                             GstMessage *message,
                                             gpointer data);

GstMessage* gst_bus_poll                    (GstBus *bus,
                                             GstMessageType events,
                                             GstClockTimeDiff timeout);

#endif

#endif
