/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamercapabilities.h"

QbtGStreamerCapabilities::QbtGStreamerCapabilities()
{
}

QbtGStreamerCapabilities::~QbtGStreamerCapabilities()
{
}

QString QbtGStreamerCapabilities::toString()
{
    QString returnString(gst_caps_to_string(m_caps));
    return returnString;
}

QbtGStreamerCapabilities* QbtGStreamerCapabilities::intersect(QbtGStreamerCapabilities* caps)
{
    if(!caps->gstCaps())
        return 0;

    GstCaps* newcaps = gst_caps_intersect(m_caps, caps->gstCaps());

    QbtGStreamerCapabilities* btCaps = new QbtGStreamerCapabilities;
    btCaps->setGstCaps(newcaps);

    return btCaps;
}

bool QbtGStreamerCapabilities::isEmpty()
{
    return gst_caps_is_empty(m_caps);
}

void QbtGStreamerCapabilities::setGstCaps(GstCaps* caps)
{
    m_caps = caps;
}

GstCaps* QbtGStreamerCapabilities::gstCaps()
{
    return m_caps;
}
