/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERCLOCK
#define QBTGSTREAMERCLOCK

#include "qbtgstreamerobject.h"

#include <QtGlobal>

#include <gst/gst.h>

typedef quint64 QbtGStreamerClockTime;

class QbtGStreamerClock : public QbtGStreamerObject
{
public:
    QbtGStreamerClock();
    ~QbtGStreamerClock();

    void setGstClock(GstClock *clock);
    GstClock *gstClock();

protected:
    GstClock *m_clock;
};

#if 0
            GstClock;
            GstClockClass;
typedef     GstClockTime;
typedef     GstClockTimeDiff;
typedef     GstClockID;
#define     GST_CLOCK_TIME_NONE
#define     GST_CLOCK_TIME_IS_VALID         (time)
#define     GST_SECOND
#define     GST_MSECOND
#define     GST_USECOND
#define     GST_NSECOND
#define     GST_CLOCK_DIFF                  (s, e)
#define     GST_TIMEVAL_TO_TIME             (tv)
#define     GST_TIME_TO_TIMEVAL             (t,tv)
#define     GST_TIMESPEC_TO_TIME            (ts)
#define     GST_TIME_TO_TIMESPEC            (t,ts)
#define     GST_CLOCK_ENTRY_TRACE_NAME
            GstClockEntry;
gboolean    (*GstClockCallback)             (GstClock *clock,
                                             GstClockTime time,
                                             GstClockID id,
                                             gpointer user_data);
enum        GstClockEntryType;
#define     GST_CLOCK_ENTRY                 (entry)
#define     GST_CLOCK_ENTRY_CLOCK           (entry)
#define     GST_CLOCK_ENTRY_TYPE            (entry)
#define     GST_CLOCK_ENTRY_TIME            (entry)
#define     GST_CLOCK_ENTRY_INTERVAL        (entry)
#define     GST_CLOCK_ENTRY_STATUS          (entry)
enum        GstClockReturn;
enum        GstClockFlags;
#define     GST_CLOCK_FLAGS                 (clock)
#define     GST_CLOCK_BROADCAST             (clock)
#define     GST_CLOCK_COND                  (clock)
#define     GST_CLOCK_TIMED_WAIT            (clock,tv)
#define     GST_CLOCK_WAIT                  (clock)
gboolean    gst_clock_add_observation       (GstClock *clock,
                                             GstClockTime slave,
                                             GstClockTime master,
                                             gdouble *r_squared);
gboolean    gst_clock_set_master            (GstClock *clock,
                                             GstClock *master);
GstClock*   gst_clock_get_master            (GstClock *clock);
GstClockTime gst_clock_set_resolution       (GstClock *clock,
                                             GstClockTime resolution);
GstClockTime gst_clock_get_resolution       (GstClock *clock);
GstClockTime gst_clock_get_time             (GstClock *clock);
GstClockID  gst_clock_new_single_shot_id    (GstClock *clock,
                                             GstClockTime time);
GstClockID  gst_clock_new_periodic_id       (GstClock *clock,
                                             GstClockTime start_time,
                                             GstClockTime interval);
GstClockTime gst_clock_get_internal_time    (GstClock *clock);
GstClockTime gst_clock_adjust_unlocked      (GstClock *clock,
                                             GstClockTime internal);
void        gst_clock_get_calibration       (GstClock *clock,
                                             GstClockTime *internal,
                                             GstClockTime *external,
                                             GstClockTime *rate_num,
                                             GstClockTime *rate_denom);
void        gst_clock_set_calibration       (GstClock *clock,
                                             GstClockTime internal,
                                             GstClockTime external,
                                             GstClockTime rate_num,
                                             GstClockTime rate_denom);
GstClockTime gst_clock_id_get_time          (GstClockID id);
GstClockReturn gst_clock_id_wait            (GstClockID id,
                                             GstClockTimeDiff *jitter);
GstClockReturn gst_clock_id_wait_async      (GstClockID id,
                                             GstClockCallback func,
                                             gpointer user_data);
void        gst_clock_id_unschedule         (GstClockID id);
gint        gst_clock_id_compare_func       (gconstpointer id1,
                                             gconstpointer id2);
GstClockID  gst_clock_id_ref                (GstClockID id);
void        gst_clock_id_unref              (GstClockID id);
#define     GST_TYPE_CLOCK_TIME
#endif

#endif
