/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERELEMENTFACTORY
#define QBTGSTREAMERELEMENTFACTORY

#include "qbtgstreamerpluginfeature.h"
#include "qbtgstreamerelement.h"
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

#include <QList>
#include <QString>
#include <QStringList>

struct QbtGStreamerElementDetails
{
  QString longName;
  QString klass;
  QString description;
  QString author;
};

class QBTGSTREAMER_EXPORT QbtGStreamerElementFactory : public QbtGStreamerPluginFeature
{
public:
    QbtGStreamerElementFactory();
    ~QbtGStreamerElementFactory();

    static QbtGStreamerElement *makeElement(const QString& factoryName, const QString& name);

    /*const gchar* gst_element_factory_get_klass  (GstElementFactory *factory);*/
    QString klass();
    QString longName();
    QString description();
    QString author();

    QStringList uriProtocols();

    void setGstElementFactory(GstElementFactory* factory);
    bool fromPluginFeature(QbtGStreamerPluginFeature* feature);
    GstElementFactory* gstElementFactory();

private:
    GstElementFactory* m_factory;
};
#if 0



            GstElementFactory;
            GstElementDetails;
#define     GST_ELEMENT_DETAILS             (longname,klass,description,author)
#define     GST_IS_ELEMENT_DETAILS          (details)
gboolean    gst_element_register            (GstPlugin *plugin,
                                             const gchar *name,
                                             guint rank,
                                             GType type);
GstElementFactory* gst_element_factory_find (const gchar *name);
GType       gst_element_factory_get_element_type
                                            (GstElementFactory *factory);
const gchar* gst_element_factory_get_longname
                                            (GstElementFactory *factory);

const gchar* gst_element_factory_get_description
                                            (GstElementFactory *factory);
const gchar* gst_element_factory_get_author (GstElementFactory *factory);
guint       gst_element_factory_get_num_pad_templates
                                            (GstElementFactory *factory);
gint        gst_element_factory_get_uri_type
                                            (GstElementFactory *factory);
gchar**     gst_element_factory_get_uri_protocols
                                            (GstElementFactory *factory);
GstElement* gst_element_factory_create      (GstElementFactory *factory,
                                             const gchar *name);
GstElement* gst_element_factory_make        (const gchar *factoryname,
                                             const gchar *name);
gboolean    gst_element_factory_can_sink_caps
                                            (GstElementFactory *factory,
                                             const GstCaps *caps);
gboolean    gst_element_factory_can_src_caps
                                            (GstElementFactory *factory,
                                             const GstCaps *caps);
const GList* gst_element_factory_get_static_pad_templates
                                            (GstElementFactory *factory);
#endif

#endif
