/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamerpluginfeature.h"

QbtGStreamerPluginFeature::QbtGStreamerPluginFeature()
{
}

QbtGStreamerPluginFeature::~QbtGStreamerPluginFeature()
{
}

void QbtGStreamerPluginFeature::setRank(uint rank)
{
    gst_plugin_feature_set_rank(m_pluginFeature, rank);
}

uint QbtGStreamerPluginFeature::rank()
{
    return gst_plugin_feature_get_rank(m_pluginFeature);
}

void QbtGStreamerPluginFeature::setName(const QString& name)
{
    gst_plugin_feature_set_name(m_pluginFeature, name.toLocal8Bit().data());
}

QString QbtGStreamerPluginFeature::name()
{
    QString str(gst_plugin_feature_get_name(m_pluginFeature));
    return str;
}

QbtGStreamerPluginFeature *QbtGStreamerPluginFeature::load()
{
    QbtGStreamerPluginFeature *feature = new QbtGStreamerPluginFeature;

    GstPluginFeature *gstFeature = gst_plugin_feature_load(m_pluginFeature);

    feature->setGstPluginFeature(gstFeature);
    return feature;
}

bool QbtGStreamerPluginFeature::isElementFactory()
{
    return GST_IS_ELEMENT_FACTORY(m_pluginFeature);
}

bool QbtGStreamerPluginFeature::isTypeFindFactory()
{
    return GST_IS_TYPE_FIND_FACTORY(m_pluginFeature);
}

void QbtGStreamerPluginFeature::setGstPluginFeature(GstPluginFeature *pluginFeature)
{
    m_pluginFeature = pluginFeature;
}

GstPluginFeature *QbtGStreamerPluginFeature::gstPluginFeature()
{
    return m_pluginFeature;
}

