/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERPLUGINFEATURE
#define QBTGSTREAMERPLUGINFEATURE

#include "qbtgstreamerobject.h"
#include <QString>
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

class QBTGSTREAMER_EXPORT QbtGStreamerPluginFeature : QbtGStreamerObject
{
public:
    QbtGStreamerPluginFeature();
    ~QbtGStreamerPluginFeature();

    /*void gst_plugin_feature_set_rank(GstPluginFeature *feature, guint rank);*/
    void setRank(uint rank);

    /*guint gst_plugin_feature_get_rank(GstPluginFeature *feature);*/
    uint rank();

    /*void gst_plugin_feature_set_name(GstPluginFeature *feature, const gchar *name);*/
    void setName(const QString& name);

    /*const gchar* gst_plugin_feature_get_name(GstPluginFeature *feature);*/
    QString name();

    /*GstPluginFeature* gst_plugin_feature_load(GstPluginFeature *feature);*/
    QbtGStreamerPluginFeature *load();

    bool isElementFactory();
    bool isTypeFindFactory();

    void setGstPluginFeature(GstPluginFeature *pluginFeature);
    GstPluginFeature *gstPluginFeature();

protected:
    GstPluginFeature *m_pluginFeature;
};



#if 0



            GstPluginFeature;
#define     GST_PLUGIN_FEATURE_NAME         (feature)
            GstTypeNameData;
gboolean    (*GstPluginFeatureFilter)       (GstPluginFeature *feature,
                                             gpointer user_data);
enum        GstRank;
gboolean    gst_plugin_feature_type_name_filter
                                            (GstPluginFeature *feature,
                                             GstTypeNameData *data);

void        gst_plugin_feature_list_free    (GList *list);
gboolean    gst_plugin_feature_check_version
                                            (GstPluginFeature *feature,
                                             guint min_major,
                                             guint min_minor,
                                             guint min_micro);
#endif

#endif

