/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERREGISTRY
#define QBTGSTREAMERREGISTRY

#include "qbtgstreamerobject.h"
#include "qbtgstreamerpluginfeature.h"
#include "qbtgstreamerdatapointer.h"
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

class QBTGSTREAMER_EXPORT QbtGStreamerRegistry : public QbtGStreamerObject
{
public:
    QbtGStreamerRegistry();
    ~QbtGStreamerRegistry();

    /* GstRegistry* gst_registry_get_default(void); */
    static QbtGStreamerRegistry* defaultRegistry();
    void makeDefault();

    QList<QbtGStreamerPluginFeature*> featureList();
    QbtGStreamerPluginFeature* featureListFirst();

    virtual bool featureFilter(QbtGStreamerPluginFeature* feature, QbtGStreamerDataPointer* data) = 0;

    void setGstRegistry(GstRegistry* registry);
    GstRegistry* gstRegistry();

protected:
    GstRegistry* m_registry;

private:
    static gboolean cb_featureFilter(GstPluginFeature* feature, gpointer data);

};

class QbtGStreamerDefaultRegistry : public QbtGStreamerRegistry
{
public:
    virtual bool featureFilter(QbtGStreamerPluginFeature* feature, QbtGStreamerDataPointer* data);
};

#if 0

GList*      gst_registry_get_feature_list   (GstRegistry *registry,
                                             GType type);
GList*      gst_registry_get_feature_list_by_plugin
                                            (GstRegistry *registry,
                                             const gchar *name);
GList*      gst_registry_get_path_list      (GstRegistry *registry);
GList*      gst_registry_get_plugin_list    (GstRegistry *registry);
gboolean    gst_registry_add_plugin         (GstRegistry *registry,
                                             GstPlugin *plugin);
void        gst_registry_remove_plugin      (GstRegistry *registry,
                                             GstPlugin *plugin);
GList*      gst_registry_plugin_filter      (GstRegistry *registry,
                                             GstPluginFilter filter,
                                             gboolean first,
                                             gpointer user_data);

GstPlugin*  gst_registry_find_plugin        (GstRegistry *registry,
                                             const gchar *name);
GstPluginFeature* gst_registry_find_feature (GstRegistry *registry,
                                             const gchar *name,
                                             GType type);
GstPluginFeature* gst_registry_lookup_feature
                                            (GstRegistry *registry,
                                             const char *name);
gboolean    gst_registry_scan_path          (GstRegistry *registry,
                                             const gchar *path);
gboolean    gst_registry_xml_read_cache     (GstRegistry *registry,
                                             const char *location);
gboolean    gst_registry_xml_write_cache    (GstRegistry *registry,
                                             const char *location);
GstPlugin*  gst_registry_lookup             (GstRegistry *registry,
                                             const char *filename);
void        gst_registry_remove_feature     (GstRegistry *registry,
                                             GstPluginFeature *feature);
gboolean    gst_registry_add_feature        (GstRegistry *registry,
                                             GstPluginFeature *feature);

gboolean    gst_default_registry_check_feature_version
                                            (const gchar *feature_name,
                                             guint min_major,
                                             guint min_minor,
                                             guint min_micro);
#define     gst_default_registry_get_path_list()
#define     gst_default_registry_add_plugin (plugin)
#define     gst_default_registry_add_path   (path)
#define     gst_default_registry_find_plugin(name)
#define     gst_default_registry_find_feature(name,type)
#define     gst_default_registry_get_plugin_list()
#define     gst_default_registry_feature_filter(filter,first,user_data)
#endif


#endif
