/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERSTRUCTURE
#define QBTGSTREAMERSTRUCTURE

#include <QString>

#include "qbtgstreamerdatapointer.h"

#include <gst/gst.h>

class QbtGStreamerStructure
{
public:
    QbtGStreamerStructure();

    /*GstStructure* gst_structure_empty_new(const gchar *name);*/
    QbtGStreamerStructure(const QString& name);

    /*const GValue* gst_structure_get_value(const GstStructure *structure, const gchar *fieldname);*/
    QString value(const QString& fieldName);

    void setGstStructure(GstStructure *structure);
    GstStructure *gstStructure();

private:
    GstStructure *m_structure;
};

#if 0
#include <gst/gst.h>


            GstStructure;
gboolean    (*GstStructureForeachFunc)      (GQuark field_id,
                                             const GValue *value,
                                             gpointer user_data);
gboolean    (*GstStructureMapFunc)          (GQuark field_id,
                                             GValue *value,
                                             gpointer user_data);

GstStructure* gst_structure_id_empty_new    (GQuark quark);
GstStructure* gst_structure_new             (const gchar *name,
                                             const gchar *firstfield,
                                             ...);
GstStructure* gst_structure_new_valist      (const gchar *name,
                                             const gchar *firstfield,
                                             va_list varargs);
GstStructure* gst_structure_copy            (const GstStructure *structure);
void        gst_structure_free              (GstStructure *structure);
const gchar* gst_structure_get_name         (const GstStructure *structure);
gboolean    gst_structure_has_name          (const GstStructure *structure,
                                             const gchar *name);
void        gst_structure_set_name          (GstStructure *structure,
                                             const gchar *name);
GQuark      gst_structure_get_name_id       (const GstStructure *structure);
const GValue* gst_structure_id_get_value    (const GstStructure *structure,
                                             GQuark field);
void        gst_structure_id_set_value      (GstStructure *structure,
                                             GQuark field,
                                             const GValue *value);
const GValue* gst_structure_get_value       (const GstStructure *structure,
                                             const gchar *fieldname);
void        gst_structure_set_value         (GstStructure *structure,
                                             const gchar *fieldname,
                                             const GValue *value);
void        gst_structure_set               (GstStructure *structure,
                                             const gchar *fieldname,
                                             ...);
void        gst_structure_set_valist        (GstStructure *structure,
                                             const gchar *fieldname,
                                             va_list varargs);
void        gst_structure_id_set            (GstStructure *structure,
                                             GQuark fieldname,
                                             ...);
void        gst_structure_id_set_valist     (GstStructure *structure,
                                             GQuark fieldname,
                                             va_list varargs);
void        gst_structure_remove_field      (GstStructure *structure,
                                             const gchar *fieldname);
void        gst_structure_remove_fields     (GstStructure *structure,
                                             const gchar *fieldname,
                                             ...);
void        gst_structure_remove_fields_valist
                                            (GstStructure *structure,
                                             const gchar *fieldname,
                                             va_list varargs);
void        gst_structure_remove_all_fields (GstStructure *structure);
GType       gst_structure_get_field_type    (const GstStructure *structure,
                                             const gchar *fieldname);
gboolean    gst_structure_foreach           (const GstStructure *structure,
                                             GstStructureForeachFunc func,
                                             gpointer user_data);
gint        gst_structure_n_fields          (const GstStructure *structure);
gboolean    gst_structure_has_field         (const GstStructure *structure,
                                             const gchar *fieldname);
gboolean    gst_structure_has_field_typed   (const GstStructure *structure,
                                             const gchar *fieldname,
                                             GType type);
gboolean    gst_structure_get_boolean       (const GstStructure *structure,
                                             const gchar *fieldname,
                                             gboolean *value);
gboolean    gst_structure_get_int           (const GstStructure *structure,
                                             const gchar *fieldname,
                                             gint *value);
gboolean    gst_structure_get_fourcc        (const GstStructure *structure,
                                             const gchar *fieldname,
                                             guint32 *value);
gboolean    gst_structure_get_double        (const GstStructure *structure,
                                             const gchar *fieldname,
                                             gdouble *value);
const gchar* gst_structure_get_string       (const GstStructure *structure,
                                             const gchar *fieldname);
gboolean    gst_structure_get_date          (const GstStructure *structure,
                                             const gchar *fieldname,
                                             GDate **value);
gboolean    gst_structure_get_clock_time    (const GstStructure *structure,
                                             const gchar *fieldname,
                                             GstClockTime *value);
gboolean    gst_structure_get_enum          (const GstStructure *structure,
                                             const gchar *fieldname,
                                             GType enumtype,
                                             gint *value);
gboolean    gst_structure_get_fraction      (const GstStructure *structure,
                                             const gchar *fieldname,
                                             gint *value_numerator,
                                             gint *value_denominator);
gboolean    gst_structure_map_in_place      (GstStructure *structure,
                                             GstStructureMapFunc func,
                                             gpointer user_data);
const gchar* gst_structure_nth_field_name   (const GstStructure *structure,
                                             guint index);
void        gst_structure_set_parent_refcount
                                            (GstStructure *structure,
                                             gint *refcount);
gchar*      gst_structure_to_string         (const GstStructure *structure);
GstStructure* gst_structure_from_string     (const gchar *string,
                                             gchar **end);
gboolean    gst_structure_fixate_field_nearest_int
                                            (GstStructure *structure,
                                             const char *field_name,
                                             int target);
gboolean    gst_structure_fixate_field_nearest_double
                                            (GstStructure *structure,
                                             const char *field_name,
                                             double target);
gboolean    gst_structure_fixate_field_nearest_fraction
                                            (GstStructure *structure,
                                             const char *field_name,
                                             const gint target_numerator,
                                             const gint target_denominator);
gboolean    gst_structure_fixate_field_boolean
                                            (GstStructure *structure,
                                             const char *field_name,
                                             gboolean target);
#endif

#endif
