/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamertypefindfactory.h"
//#include "qbtgstreamercallbackmanager.h"

#include <QtDebug>

//QbtGStreamerTypeFindFactory *QbtGStreamerTypeFindFactory::s_instance;

QbtGStreamerTypeFindFactory::QbtGStreamerTypeFindFactory()
{
    //s_instance = this;
}

QbtGStreamerTypeFindFactory::~QbtGStreamerTypeFindFactory()
{
}

QList<QbtGStreamerTypeFindFactory *> QbtGStreamerTypeFindFactory::list()
{
    //qDebug() << "QbtGStreamer debug: QList<QbtGStreamerTypeFindFactory *> QbtGStreamerTypeFindFactory::list()";

    QList<QbtGStreamerTypeFindFactory*> returnList;

    GList* list;
    const GList *item;

    list = gst_type_find_factory_get_list();

    for (item = list; item != NULL; item = item->next) {
        //qDebug() << "QbtGStreamer debug: item";
        QbtGStreamerTypeFindFactory* btTFFactory = new QbtGStreamerTypeFindFactory;
        btTFFactory->setGstTypeFindFactory(GST_TYPE_FIND_FACTORY(item->data));
        returnList.append(btTFFactory);
    }

    return returnList;
}

QStringList QbtGStreamerTypeFindFactory::extensions()
{
    if (!m_factory)
        return QStringList();

    QStringList returnList;
    gchar **extensions;

    extensions = gst_type_find_factory_get_extensions(m_factory);
    if (extensions) {
        gchar *extension;
        while ((extension = *(extensions++)) != NULL) {
            QString s(extension);
            returnList << s;
        }
    }

    return returnList;
}

void QbtGStreamerTypeFindFactory::setGstTypeFindFactory(GstTypeFindFactory* factory)
{
    m_factory = factory;
}

bool QbtGStreamerTypeFindFactory::fromPluginFeature(QbtGStreamerPluginFeature* feature)
{
    if(!feature->isTypeFindFactory())
        return false;

    m_factory = GST_TYPE_FIND_FACTORY(feature->gstPluginFeature());
    return true;
}

GstTypeFindFactory* QbtGStreamerTypeFindFactory::gstTypeFindFactory()
{
    return m_factory;
}
