/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */ 
#include "configdialog.h"
#include "hostlist.h"
#include "hostlistdelegate.h"

#include <kdebug.h>

#include <QCheckBox>
#include <QTableWidgetItem>
#include <QVariant>
#include <QComboBox>
#include <Qt>


ConfigDialog::ConfigDialog() : QDialog()
{
	kDebug() << k_funcinfo << endl;

	m_view = new Ui::ConfigWidget();
	m_view->setupUi(this);

	m_user_list = new HostList(this);

	m_view->hostsView->setModel(m_user_list);

	HostListDelegate* delegate = new HostListDelegate();
	m_view->hostsView->setItemDelegate(delegate);
	m_view->hostsView->setColumnWidth(1, 50);
	m_view->hostsView->setColumnWidth(2, 50);
	m_view->hostsView->setColumnWidth(3, 125);
	m_view->hostsView->setColumnWidth(4, 125);

	connect( m_view->addButton, SIGNAL( clicked( ) ), m_user_list, SLOT( addRow( ) ) );
	connect( m_view->okButton, SIGNAL( clicked( ) ), this, SLOT( okButtonClicked( ) ) );
	connect( m_view->cancelButton, SIGNAL( clicked( ) ), this, SLOT( close( ) ) );

}

ConfigDialog::~ConfigDialog()
{
	kDebug() << k_funcinfo << endl;
	delete m_view;
}

void ConfigDialog::okButtonClicked()
{
	m_user_list->addBranches();
	close();
}

#include "configdialog.moc"
