/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */ 

#include <dcopclient.h>
#include <kdebug.h>

#include "configproxy.h"
#include "configproxy.moc"



namespace Phonon
{
namespace nmm
{

ConfigProxy::ConfigProxy(GraphHandler* graphHandler): DCOPObject("ConfigProxy")
{
	m_graphHandler = graphHandler;
}

ConfigProxy::~ConfigProxy()
{
}




bool ConfigProxy::addBranch(const int streamId, QString& sink_nd)
{
	try
	{
		NodeDescription nd(sink_nd.toUtf8().data());
		string tag;
		if (sink_nd.contains("Display"))
			tag = m_graphHandler->getVideoStreamName(streamId);
		else if (sink_nd.contains("Playback"))
			tag = m_graphHandler->getAudioStreamName(streamId);

		const string tag_str = tag;
		kDebug() << "adding branch: " << QString::fromStdString(tag_str) << ", " << sink_nd << endl;
		int id = m_graphHandler->addBranch(tag_str, nd);
		return (id >0);
	}
	catch(const Exception& e)
	{
		//cerr << QString::fromStdString(e) << endl;
		return false;
	}
}

bool ConfigProxy::addRemoteBranch(const int streamId, QString& sink_nd, QString& hostname)
{
	try
	{
		NodeDescription nd(sink_nd.toUtf8().data());
		nd.setLocation(hostname.toUtf8().data());
		string tag;
		if (sink_nd.contains("Display"))
			tag = m_graphHandler->getVideoStreamName(streamId);
		else if (sink_nd.contains("Playback"))
			tag = m_graphHandler->getAudioStreamName(streamId);

		const string tag_str = tag;
		kDebug() << "adding branch@" << hostname << ": " << QString::fromStdString(tag_str) << ", " << sink_nd << endl;
		int id = m_graphHandler->addBranch(tag_str, nd);
		return (id >0);
	}
	catch(const Exception& e)
	{
		//cerr << e << endl;
		return false;
	}
}

QStringList ConfigProxy::getBranch(int id)
{
	QStringList branch;
	string hostname;
	string sink;
	string tag;
	int streamId;
	if (m_graphHandler->getBranch(id, hostname, sink, tag))
	{
		QString tmp = QString::fromStdString(tag).right(1);
		bool valid;
		tmp.toInt(&valid);
		if (!valid) //tag might be "default". in that case id is "0".
			tmp = "0";
		branch << QString::fromStdString(hostname) << QString::fromStdString(sink) << tmp;
	}
	return branch; 
}

QList<int> ConfigProxy::getBranchIds()
{
	list<int> idList = m_graphHandler->getBranchIds();

	QList<int> ids = QList<int>::fromStdList(idList);
	
	return ids;
}

bool ConfigProxy::removeBranch(int id)
{
	return m_graphHandler->removeBranch(id);
}


}}
// vim: sw=4 ts=4 tw=80 noet
