/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#ifndef Phonon_NMM_MEDIAOBJECT_H
#define Phonon_NMM_MEDIAOBJECT_H

#include "abstractmediaproducer.h"
#include <kurl.h>
#include <phonon/mediaobjectinterface.h>

class KUrl;

namespace Phonon
{
namespace nmm
{
	class MediaObject : public AbstractMediaProducer, public MediaObjectInterface
	{
		Q_OBJECT
		Q_INTERFACES( Phonon::MediaObjectInterface )
		public:
			MediaObject( Backend* backend, QObject* parent );
			~MediaObject();
			Q_INVOKABLE KUrl url() const;
			//Q_INVOKABLE qint64 remainingTime() const;
			Q_INVOKABLE void setUrl( const KUrl& url );
			Q_INVOKABLE void play();
			Q_INVOKABLE void pause();
			Q_INVOKABLE void seek( qint64 time );
			Q_INVOKABLE qint64 totalTime() const;

		public Q_SLOTS:
			void stop();

		private:
			Q_INVOKABLE void registerEventHandler();

			Backend* m_backend;
	};
}} //namespace Phonon::nmm

#endif
// vim: sw=4 ts=4 tw=80 noet
