/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
#ifndef Phonon_NMM_VIDEODATAOUTPUT_H
#define Phonon_NMM_VIDEODATAOUTPUT_H

#include "abstractvideooutput.h"
#include <phonon/videoframe.h>
#include <QVector>
#include <QByteArray>
#include <QObject>
#include <QSize>

namespace Phonon
{
namespace nmm
{

	class VideoDataOutput : public QObject, public Phonon::nmm::AbstractVideoOutput
	{
		Q_OBJECT
		public:
			VideoDataOutput( QObject* parent );
			~VideoDataOutput();

		public slots:
			int frameRate() const;
			void setFrameRate( int frameRate );

			QSize naturalFrameSize() const;
			QSize frameSize() const;
			void setFrameSize( const QSize& frameSize );

			quint32 format() const;
			void setFormat( quint32 format );

		signals:
			void frameReady( const Phonon::VideoFrame& frame );
			void endOfMedia();

		private:
			quint32 m_fourcc;
			QByteArray m_pendingData;
			int m_frameRate;
			QSize m_frameSize;
	};
}} //namespace Phonon::nmm

#endif // Phonon_NMM_VIDEODATAOUTPUT_H
// vim: sw=4 ts=4 tw=80 noet
