// kcm_noatun_systray.cpp
//
// Copyright 2004 Stefan Gehn <metz AT gehn DOT net>
// Copyright 2001 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include "systray_prefs.h"
#include "systray_prefswidget.h"
#include "yhconfig.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtabwidget.h>

#include <kdebug.h>
#include <klocale.h>

using namespace Noatun;

SystrayPrefs::SystrayPrefs(Global *glob, QObject *parent)
	: PreferencesPage(glob, parent, i18n("Systemtray"), i18n("Configure Systray"), "gear")
{
	QFrame *parentWidget = frame();
	QVBoxLayout *top = new QVBoxLayout(parentWidget);
	mWidget = new SystrayPrefsWidget(parentWidget);
	top->addWidget(mWidget);

	mWidget->cmbModifier->insertItem(i18n("None"), YHConfig::NoModifier);
	mWidget->cmbModifier->insertItem(i18n("Shift"), YHConfig::ShiftModifier);
	mWidget->cmbModifier->insertItem(i18n("Alt"), YHConfig::AltModifier);
	mWidget->cmbModifier->insertItem(i18n("Ctrl"), YHConfig::CtrlModifier);
	mWidget->cmbModifier->setCurrentItem(YHConfig::NoModifier);

	connect(mWidget->chkEnabled, SIGNAL(toggled(bool)), this, SLOT(slotEnabledToggled(bool)));
	connect(mWidget->chkUsePopup, SIGNAL(toggled(bool)), this, SLOT(slotUsePopupToggled(bool)));
	connect(mWidget->cmbModifier, SIGNAL(activated(int)), this, SLOT(slotModifierActivated(int)));
	connect(mWidget->grpMwheel, SIGNAL(clicked(int)), this, SLOT(slotMwheelClicked(int)));

	connect(mWidget->chkEnabled, SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->chkUseTooltip, SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->chkUseCovers, SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->chkUsePopup, SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->spinPopupTimeout, SIGNAL(valueChanged(int)), this, SLOT(changed()));
	connect(mWidget->chkPopupButtons, SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->bgStateIcon, SIGNAL(clicked(int)), this, SLOT(changed()));
	connect(mWidget->rbHideShowPlaylist, SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->rbPlayPause, SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->rbActNothing, SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->rbActVolume,SIGNAL(toggled(bool)), this, SLOT(changed()));
	connect(mWidget->rbActTrack,SIGNAL(toggled(bool)), this, SLOT(changed()));
}


void SystrayPrefs::defaults()
{
	YHConfig::self()->setDefaults();
	loadInternal();
	emit changed(true);
}


void SystrayPrefs::load()
{
	kDebug(66666) ;
	YHConfig::self()->readConfig();
	loadInternal();
	emit changed(false);
}


void SystrayPrefs::loadInternal()
{
	kDebug(66666) ;
	YHConfig *c = YHConfig::self();

	mWidget->chkEnabled->setChecked(c->enabled());

	/** General TAB **/
	mWidget->chkUseTooltip->setChecked(c->tip());
	mWidget->chkUseCovers->setChecked(c->passivePopupCovers());
	mWidget->chkUsePopup->setChecked(c->passivePopup());
	mWidget->spinPopupTimeout->setValue(c->passivePopupTimeout());
	mWidget->chkPopupButtons->setChecked(c->passivePopupButtons());
	switch(c->stateIconDisplay())
	{
		case (YHConfig::Animation):
			mWidget->rbStateAnim->setChecked(true);
			break;
		case (YHConfig::FlashingIcon):
			mWidget->rbStateFlashing->setChecked(true);
			break;
		case (YHConfig::StaticIcon):
			mWidget->rbStateStatic->setChecked(true);
			break;
		case (YHConfig::NoIcon):
			mWidget->rbStateNone->setChecked(true);
			break;
	}


	/** Advanced TAB **/
	if (c->middleMouseAction() == YHConfig::PlayPause)
		mWidget->rbPlayPause->setChecked(true);
	else
		mWidget->rbHideShowPlaylist->setChecked(true);
	mActionMap[YHConfig::NoModifier]		= YHConfig::self()->mouseWheelAction(YHConfig::NoModifier);
	mActionMap[YHConfig::ShiftModifier]	= YHConfig::self()->mouseWheelAction(YHConfig::ShiftModifier);
	mActionMap[YHConfig::AltModifier]	= YHConfig::self()->mouseWheelAction(YHConfig::AltModifier);
	mActionMap[YHConfig::CtrlModifier]	= YHConfig::self()->mouseWheelAction(YHConfig::CtrlModifier);

	slotModifierActivated(mWidget->cmbModifier->currentItem());
}


void SystrayPrefs::save()
{
	kDebug(66666) ;
	YHConfig *c = YHConfig::self();

	c->setEnabled(mWidget->chkEnabled->isChecked());

	/** General TAB **/
	c->setTip(mWidget->chkUseTooltip->isChecked());
	c->setPassivePopupCovers(mWidget->chkUseCovers->isChecked());
	c->setPassivePopup(mWidget->chkUsePopup->isChecked());
	c->setPassivePopupTimeout(mWidget->spinPopupTimeout->value());
	c->setPassivePopupButtons(mWidget->chkPopupButtons->isChecked());
	if (mWidget->rbStateAnim->isChecked())
		c->setStateIconDisplay(YHConfig::Animation);
	else if (mWidget->rbStateFlashing->isChecked())
		c->setStateIconDisplay(YHConfig::FlashingIcon);
	else if (mWidget->rbStateStatic->isChecked())
		c->setStateIconDisplay(YHConfig::StaticIcon);
	else
		c->setStateIconDisplay(YHConfig::NoIcon);


	/** Advanced TAB **/
	if (mWidget->rbPlayPause->isChecked())
		c->setMiddleMouseAction(YHConfig::PlayPause);
	else
		c->setMiddleMouseAction(YHConfig::HideShowPlaylist);
	c->setMouseWheelAction(YHConfig::NoModifier, mActionMap[YHConfig::NoModifier]);
	c->setMouseWheelAction(YHConfig::ShiftModifier, mActionMap[YHConfig::ShiftModifier]);
	c->setMouseWheelAction(YHConfig::AltModifier, mActionMap[YHConfig::AltModifier]);
	c->setMouseWheelAction(YHConfig::CtrlModifier, mActionMap[YHConfig::CtrlModifier]);

	c->writeConfig();
	emit changed(false);
	emit saved();
}


void SystrayPrefs::slotUsePopupToggled(bool on)
{
	mWidget->lblPopupTimeout->setEnabled(on);
	mWidget->spinPopupTimeout->setEnabled(on);
	mWidget->chkPopupButtons->setEnabled(on);
}


void SystrayPrefs::slotModifierActivated(int index)
{
	kDebug(66666) ;
	switch(mActionMap[index])
	{
		case (YHConfig::Nothing):
			mWidget->rbActNothing->setChecked(true);
			break;
		case (YHConfig::ChangeVolume):
			mWidget->rbActVolume->setChecked(true);
			break;
		case (YHConfig::ChangeTrack):
			mWidget->rbActTrack->setChecked(true);
			break;
	}
}

void SystrayPrefs::slotMwheelClicked(int index)
{
	kDebug(66666) ;
	if (index == 0)
		mActionMap[mWidget->cmbModifier->currentItem()] = YHConfig::Nothing;
	else if (index == 1)
		mActionMap[mWidget->cmbModifier->currentItem()] = YHConfig::ChangeVolume;
	else
		mActionMap[mWidget->cmbModifier->currentItem()] = YHConfig::ChangeTrack;
}


void SystrayPrefs::slotEnabledToggled(bool on)
{
	mWidget->tabWidget->setEnabled(on);
}

#include "systray_prefs.moc"
