/***************************************************************************
                          kwifi_ifaceimpl.h  -  description
                             -------------------
    begin                : Sun Jan 22 17:44:20 CEST 2001
    copyright            : (C) 2006 by Stefan Winter
    email                : swinter@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWIFI_IFACEIMPL_H
#define KWIFI_IFACEIMPL_H

class QWidget;
class QGridLayout;
class Led;
class KSystemTrayIcon;
class KProcess;
class Statistics;
class NetworkScanning;
class QTimer;
class KWiFiManagerApp;

#include "ui_kwifi_ifacewidget.h"
#include "ui_stats_uiwidget.h"
#include "interface_wireless.h"

class KWiFi_Iface : public QWidget
{
	Q_OBJECT
	public:
		KWiFi_Iface ( KWiFiManagerApp* parent );
	public slots:
		void updateTrayIcon ( int newQual, int newSig, int newNoise );
		void updateStatsSurroundings (  );
		void updateSpeed ( signed long newSpeed );
		void updateStatus (  );
		void updateCardState ( CARDSTATES state );
		void updateStrengthBar ( int newQual, int newSig, int newNoise );
		void slotNetworkScan (  );
		void toggleStats (  );
		void slotDisableRadio (  );
		void slotTXPowerChanged (  );
		void slotToggleTric (  );
		void tricorderBeep (  );
		QString careOfInterface ( ) { return device->get_interface_name(); };
	signals:
		void interfaceChanged ( KWiFi_Iface * );
	private:
		Interface_wireless* device;
		Led* led;
		QWidget *statsContainer;
		Ui::StatisticsUI stats_ui;
		QWidget *iface_container;
		Ui::interfaceInfoWidget iface_ui;
		KSystemTrayIcon* trayicon;
		QGridLayout* zentrallayout;
		Statistics* statistik;
		signed long highestExperiencedSpeed;
		NetworkScanning * scanwidget;
		QTimer *dataUpdateTrigger, *tricorderTrigger;
		KProcess * disablePower;
	private slots:
		void slotDisablePowerProcessExited (  );
		void slotChangeInterfaceChangeNotification ();

};

#endif /* KWIFI_IFACEIMPL_H */
