/* This file is part of the KDE Project
   Copyright (c) 2004 Jakub Stachowski <qbast@go2.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "watcher.h"

#include <kdebug.h>

#include <qstringlist.h>
#include <QtDBus>
#include <kdirnotify.h>

Watcher::Watcher(const QString& type, const QString& domain) 
	: refcount(1), updateNeeded(false), m_type(type), m_domain(domain)
{
	if (domain.isEmpty()) browser = new ServiceBrowser(type);
		else browser = new ServiceBrowser(type,false, domain);
	connect(browser,SIGNAL(serviceAdded(DNSSD::RemoteService::Ptr)),
		SLOT(serviceAdded(DNSSD::RemoteService::Ptr)));
	connect(browser,SIGNAL(serviceRemoved(DNSSD::RemoteService::Ptr)),
		SLOT(serviceRemoved(DNSSD::RemoteService::Ptr)));
	connect(browser,SIGNAL(finished()),SLOT(finished()));
	browser->startBrowse();
}

Watcher::~Watcher()
{
	delete browser;
}

void Watcher::serviceAdded(DNSSD::RemoteService::Ptr)
{
	updateNeeded=true;
}

void Watcher::serviceRemoved(DNSSD::RemoteService::Ptr srv)
{
	if (!updateNeeded) removed << srv;
}


void Watcher::finished() 
{
	kDebug() << "Finished for " << m_type << "@" << m_domain << "\n";
	if (updateNeeded || removed.count()) {
		QString url = "zeroconf:/";
		if (!m_domain.isEmpty()) url+='/'+m_domain+'/';
		//FIXME: watch for types
//		if (m_type!=ServiceBrowser::AllServices) url+=m_type;
		kDebug() << "Sending update: " << url << "\n";
		org::kde::KDirNotify::emitFilesAdded( url );
		}
	removed.clear();
	updateNeeded=false;
}

#include "watcher.moc"
