#ifndef MYSTRING_H
#define MYSTRING_H

#include <string>
#include <string.h>
#include <strings.h>
#include <stdio.h>

class MyString: public std::string
{
   public:
      MyString(const char c) : std::string(1,c) {}
      MyString(const char* c)
         : std::string(c==0?"":c)
      {}
      MyString(const std::string& s) : std::string(s) {}
      MyString() : std::string() {}
      
      MyString mid(int pos, int length=-1) const {return substr(pos,length);}
      MyString left(int len) const {return substr(0,len);}
      MyString right(int len) const
      {
         if (len<1) return "";
         else if (len<int(size())) return substr(size()-len);
         else return (*this);
      }

      int contains(char c);
};

//taken from Qt/QCString
MyString trimmed(MyString str);

#endif

