/*
 *   kmoon - a moon phase indicator
 *   $Id: kmoonapplet.cpp 709224 2007-09-06 21:32:08Z amth $
 *   Copyright 1998,2000  Stephan Kulow <coolo@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#include "kmoonapplet.h"
#include "version.h"
#include "kmoondlg.h"
#include "kmoonwidget.h"

#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include <QtGui/QBitmap>
#include <QtGui/QPainter>
#include <QtGui/QMenu>
#include <QtGui/QLayout>
#include <QtGui/QPixmap>
#include <QtGui/QMouseEvent>
#include <QtCore/QTimerEvent>
#include <QtGui/QVBoxLayout>

#include <kdebug.h>
#include <kwindowsystem.h>
#include <kstartupinfo.h>
#include <kmessagebox.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kcmdlineargs.h>
#include <kiconloader.h>
#include <kiconeffect.h>
#include <kconfig.h>
#include <kdialog.h>

const char *description = I18N_NOOP("Moon Phase Indicator for KDE");

extern "C"
{
  KDE_EXPORT K3PanelApplet *init(QWidget *parent, const QString& configFile)
  {
    KGlobal::locale()->insertCatalog("kmoon");
    return new MoonPAWidget(configFile, K3PanelApplet::Normal,
			    K3PanelApplet::About|K3PanelApplet::Preferences,
			    parent, "kmoonapplet");
  }
}

MoonPAWidget::MoonPAWidget(const QString& configFile, K3PanelApplet::Type type, int actions,
			   QWidget *parent, const char *name)
  : K3PanelApplet(configFile, type, actions, parent)
{
    KConfigGroup config(KGlobal::config(), "General");

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->setSpacing(0);
    vbox->setMargin(0);
    moon = new MoonWidget(this);
    moon->setAngle(config.readEntry("Rotation", 0));
    moon->setNorthHemi(config.readEntry("Northern", true));
    moon->setMask(config.readEntry("Mask", false));
    vbox->addWidget(moon);
    startTimer(1000 * 60 * 20);

    popup = new QMenu();
    popup->addAction(SmallIcon("kmoon"),
		      i18n("&About"), this,
		      SLOT(showAbout()));
    popup->addAction(SmallIcon("configure"), i18n("&Configure..."), this,
		      SLOT(settings()));

    // missuse timerEvent for initialising
    timerEvent(0);
}

MoonPAWidget::~MoonPAWidget()
{
  delete moon;
  delete popup;
}

void MoonPAWidget::showAbout()
{
    KDialog *dialog = new KDialog( 0 );
    dialog->setButtons( KDialog::Yes );
    dialog->setDefaultButton( KDialog::Yes );
    dialog->setCaption( i18n("About Moon Phase Indicator") );
    dialog->setModal( true );
    dialog->setButtonGuiItem( KDialog::Yes,  KStandardGuiItem::ok() );

    QPixmap ret = DesktopIcon("kmoon");
    QString text = i18n(description) + QLatin1String("\n\n") +
		   i18n("Written by Stephan Kulow <coolo@kde.org>\n"
                            "\n"
                            "Made an applet by M G Berberich "
                            "<berberic@fmi.uni-passau.de>\n"
                            "\n"
                            "Lunar code by Chris Osburn "
                            "<chris@speakeasy.org>\n"
                            "\n"
                            "Moon graphics by Tim Beauchamp "
                            "<timb@googol.com>");

    dialog->setWindowIcon(ret);

    KMessageBox::createKMessageBox(dialog, ret, text, QStringList(), QString(), 0, KMessageBox::Notify);
}

void MoonPAWidget::settings()
{
	KMoonDlg dlg(moon->angle(), moon->northHemi(), moon->mask(),
		     this, "moondlg");
	if (dlg.exec() == KMoonDlg::Accepted) {
		moon->setAngle(dlg.getAngle());
                moon->setNorthHemi(dlg.getNorthHemi());
		moon->setMask(dlg.getMask());
		KConfigGroup config( KGlobal::config(), "General");
		config.writeEntry("Rotation", moon->angle());
                config.writeEntry("Northern", moon->northHemi());
                config.writeEntry("Mask", moon->mask());
                config.sync();
	}
	repaint();
}

void MoonPAWidget::timerEvent( QTimerEvent * )
{
    time_t clock;
    time(&clock);
    struct tm *t = localtime(&clock);
    moon->calcStatus(mktime(t));
    moon->repaint();
}

void MoonPAWidget::mousePressEvent( QMouseEvent *e)
{
    if (!popup)
      return;

    if (e->button() == Qt::RightButton) {
      popup->popup(mapToGlobal(e->pos()));
      popup->exec();
    }
    if (e->button() == Qt::LeftButton) {
      showAbout();
    }
}

#include "kmoonapplet.moc"
