//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Runtime.InteropServices;
	using System.Collections.Generic;

	/// <remarks>
	///  Easy message dialog box.
	///  Provides convenience functions for some i18n'ed standard dialogs.
	///  The text in message boxes is wrapped automatically. The text may either
	///  be plaintext or richtext. If the text is plaintext, a newline-character
	///  may be used to indicate the end of a paragraph.
	///  @port4 Where applicable, the static functions now take an additional
	///         argument to specify the cancel button. Since a default argument is
	///         provided, this will affect your code only, if you specified
	///         dontAskAgainName and/or options. In those cases, adding an additional
	///         parameter KStandardGuiItem.Cancel() leads to the old behavior. The
	///         following functions are affected (omitting function arguments in the
	///         list), questionYesNoCancelWId(),
	///         warningContinueCancel(), warningContinueCancelWId(),
	///         warningContinueCancelList(), warningContinueCancelListWId(),
	///         warningYesNoCancel(), warningYesNoCancelWId(),
	///         warningYesNoCancelList(), warningYesNoCancelListWId(), messageBox(),
	///         messageBoxWId().
	/// </remarks>		<author> Waldo Bastian (bastian@kde.org)
	///   </author>
	/// 		<short>    Easy message dialog box.</short>

	[SmokeClass("KMessageBox")]
	public class KMessageBox : Object, IDisposable {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KMessageBox(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KMessageBox), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KMessageBox() {
			staticInterceptor = new SmokeInvocation(typeof(KMessageBox), null);
		}
		/// <remarks>
		///  Button types.
		/// </remarks>		<short>    Button types.</short>
		public enum ButtonCode {
			Ok = 1,
			Cancel = 2,
			Yes = 3,
			No = 4,
			Continue = 5,
		}
		public enum DialogType {
			QuestionYesNo = 1,
			WarningYesNo = 2,
			WarningContinueCancel = 3,
			WarningYesNoCancel = 4,
			Information = 5,
			Sorry = 7,
			Error = 8,
			QuestionYesNoCancel = 9,
		}
		public enum Option {
			Notify = 1,
			AllowLink = 2,
			Dangerous = 4,
			PlainCaption = 8,
			NoExec = 16,
		}
		public KMessageBox() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KMessageBox", "KMessageBox()", typeof(void));
		}
		~KMessageBox() {
			interceptor.Invoke("~KMessageBox", "~KMessageBox()", typeof(void));
		}
		public void Dispose() {
			interceptor.Invoke("~KMessageBox", "~KMessageBox()", typeof(void));
		}
		/// <remarks>
		///  Display a simple "question" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Question").
		/// </param><param> name="buttonYes" The text for the first button.
		///                   The default is i18n("&Yes").
		/// </param><param> name="buttonNo" The text for the second button.
		///                   The default is i18n("&No").
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further confirmation can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Option
		/// </param> To be used for questions like "Do you have a printer?"
		///  The default button is "Yes". Pressing "Esc" selects "No".
		///   </remarks>		<return> 'Yes' is returned if the Yes-button is pressed. 'No' is returned
		///           if the No-button is pressed.
		/// </return>
		/// 		<short>    Display a simple "question" dialog.</short>
		public static int QuestionYesNo(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("questionYesNo#$$##$$", "questionYesNo(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int QuestionYesNo(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("questionYesNo#$$##$", "questionYesNo(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName);
		}
		public static int QuestionYesNo(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("questionYesNo#$$##", "questionYesNo(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int QuestionYesNo(QWidget parent, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("questionYesNo#$$#", "questionYesNo(QWidget*, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int QuestionYesNo(QWidget parent, string text, string caption) {
			return (int) staticInterceptor.Invoke("questionYesNo#$$", "questionYesNo(QWidget*, const QString&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static int QuestionYesNo(QWidget parent, string text) {
			return (int) staticInterceptor.Invoke("questionYesNo#$", "questionYesNo(QWidget*, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int QuestionYesNoWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("questionYesNoWId$$$##$$", "questionYesNoWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int QuestionYesNoWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("questionYesNoWId$$$##$", "questionYesNoWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName);
		}
		public static int QuestionYesNoWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("questionYesNoWId$$$##", "questionYesNoWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int QuestionYesNoWId(uint parent_id, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("questionYesNoWId$$$#", "questionYesNoWId(WId, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int QuestionYesNoWId(uint parent_id, string text, string caption) {
			return (int) staticInterceptor.Invoke("questionYesNoWId$$$", "questionYesNoWId(WId, const QString&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption);
		}
		public static int QuestionYesNoWId(uint parent_id, string text) {
			return (int) staticInterceptor.Invoke("questionYesNoWId$$", "questionYesNoWId(WId, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text);
		}
		/// <remarks>
		///  Display a simple "question" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Question").
		/// </param><param> name="buttonYes" The text for the first button.
		///                   The default is i18n("&Yes").
		/// </param><param> name="buttonNo" The text for the second button.
		///                   The default is i18n("&No").
		/// </param><param> name="buttonCancel" The text for the third button.
		///                   The default is i18n("&Cancel").
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further confirmation can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Options
		/// </param> To be used for questions like "Do you want to discard the message or save it for later?",
		///  The default button is "Yes". Pressing "Esc" selects "Cancel".
		///   </remarks>		<return> 'Yes' is returned if the Yes-button is pressed. 'No' is returned
		///           if the No-button is pressed.
		/// </return>
		/// 		<short>    Display a simple "question" dialog.</short>
		public static int QuestionYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("questionYesNoCancel#$$###$$", "questionYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int QuestionYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("questionYesNoCancel#$$###$", "questionYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int QuestionYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("questionYesNoCancel#$$###", "questionYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel);
		}
		public static int QuestionYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("questionYesNoCancel#$$##", "questionYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int QuestionYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("questionYesNoCancel#$$#", "questionYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int QuestionYesNoCancel(QWidget parent, string text, string caption) {
			return (int) staticInterceptor.Invoke("questionYesNoCancel#$$", "questionYesNoCancel(QWidget*, const QString&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static int QuestionYesNoCancel(QWidget parent, string text) {
			return (int) staticInterceptor.Invoke("questionYesNoCancel#$", "questionYesNoCancel(QWidget*, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int QuestionYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("questionYesNoCancelWId$$$###$$", "questionYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int QuestionYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("questionYesNoCancelWId$$$###$", "questionYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int QuestionYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("questionYesNoCancelWId$$$###", "questionYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel);
		}
		public static int QuestionYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("questionYesNoCancelWId$$$##", "questionYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int QuestionYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("questionYesNoCancelWId$$$#", "questionYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int QuestionYesNoCancelWId(uint parent_id, string text, string caption) {
			return (int) staticInterceptor.Invoke("questionYesNoCancelWId$$$", "questionYesNoCancelWId(WId, const QString&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption);
		}
		public static int QuestionYesNoCancelWId(uint parent_id, string text) {
			return (int) staticInterceptor.Invoke("questionYesNoCancelWId$$", "questionYesNoCancelWId(WId, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text);
		}
		/// <remarks>
		///  Display a "question" dialog with a listbox to show information to the user
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="strlist" List of strings to be written in the listbox. If the list is
		///                 empty, it doesn't show any listbox, working as questionYesNo.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Question").
		/// </param><param> name="buttonYes" The text for the first button.
		///                   The default is i18n("&Yes").
		/// </param><param> name="buttonNo" The text for the second button.
		///                   The default is i18n("&No").
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further confirmation can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Options
		/// </param> To be used for questions like "Do you really want to delete these files?"
		///  And show the user exactly which files are going to be deleted in case
		///  he presses "Yes"
		///  The default button is "Yes". Pressing "Esc" selects "No".
		///   </remarks>		<return> 'Yes' is returned if the Yes-button is pressed. 'No' is returned
		///           if the No-button is pressed.
		/// </return>
		/// 		<short>    Display a "question" dialog with a listbox to show information to the user </short>
		public static int QuestionYesNoList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("questionYesNoList#$?$##$$", "questionYesNoList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int QuestionYesNoList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("questionYesNoList#$?$##$", "questionYesNoList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName);
		}
		public static int QuestionYesNoList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("questionYesNoList#$?$##", "questionYesNoList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int QuestionYesNoList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("questionYesNoList#$?$#", "questionYesNoList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int QuestionYesNoList(QWidget parent, string text, List<string> strlist, string caption) {
			return (int) staticInterceptor.Invoke("questionYesNoList#$?$", "questionYesNoList(QWidget*, const QString&, const QStringList&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static int QuestionYesNoList(QWidget parent, string text, List<string> strlist) {
			return (int) staticInterceptor.Invoke("questionYesNoList#$?", "questionYesNoList(QWidget*, const QString&, const QStringList&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int QuestionYesNoListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("questionYesNoListWId$$?$##$$", "questionYesNoListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int QuestionYesNoListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("questionYesNoListWId$$?$##$", "questionYesNoListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName);
		}
		public static int QuestionYesNoListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("questionYesNoListWId$$?$##", "questionYesNoListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int QuestionYesNoListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("questionYesNoListWId$$?$#", "questionYesNoListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int QuestionYesNoListWId(uint parent_id, string text, List<string> strlist, string caption) {
			return (int) staticInterceptor.Invoke("questionYesNoListWId$$?$", "questionYesNoListWId(WId, const QString&, const QStringList&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static int QuestionYesNoListWId(uint parent_id, string text, List<string> strlist) {
			return (int) staticInterceptor.Invoke("questionYesNoListWId$$?", "questionYesNoListWId(WId, const QString&, const QStringList&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  Display a "warning" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Warning").
		/// </param><param> name="buttonYes" The text for the first button.
		///                   The default is i18n("&Yes").
		/// </param><param> name="buttonNo" The text for the second button.
		///                   The default is i18n("&No").
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further confirmation can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Options
		/// </param> To be used for questions "Shall I update your configuration?"
		///  The text should explain the implication of both options.
		///  The default button is "No". Pressing "Esc" selects "No".
		///   </remarks>		<return> <code>Yes</code> is returned if the Yes-button is pressed. <code>No</code> is returned
		///           if the No-button is pressed.
		/// </return>
		/// 		<short>    Display a "warning" dialog.</short>
		public static int WarningYesNo(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningYesNo#$$##$$", "warningYesNo(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningYesNo(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningYesNo#$$##$", "warningYesNo(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName);
		}
		public static int WarningYesNo(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("warningYesNo#$$##", "warningYesNo(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int WarningYesNo(QWidget parent, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("warningYesNo#$$#", "warningYesNo(QWidget*, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int WarningYesNo(QWidget parent, string text, string caption) {
			return (int) staticInterceptor.Invoke("warningYesNo#$$", "warningYesNo(QWidget*, const QString&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static int WarningYesNo(QWidget parent, string text) {
			return (int) staticInterceptor.Invoke("warningYesNo#$", "warningYesNo(QWidget*, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int WarningYesNoWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningYesNoWId$$$##$$", "warningYesNoWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningYesNoWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningYesNoWId$$$##$", "warningYesNoWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName);
		}
		public static int WarningYesNoWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("warningYesNoWId$$$##", "warningYesNoWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int WarningYesNoWId(uint parent_id, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("warningYesNoWId$$$#", "warningYesNoWId(WId, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int WarningYesNoWId(uint parent_id, string text, string caption) {
			return (int) staticInterceptor.Invoke("warningYesNoWId$$$", "warningYesNoWId(WId, const QString&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption);
		}
		public static int WarningYesNoWId(uint parent_id, string text) {
			return (int) staticInterceptor.Invoke("warningYesNoWId$$", "warningYesNoWId(WId, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text);
		}
		/// <remarks>
		///  Display a "warning" dialog with a listbox to show information to the user
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="strlist" List of strings to be written in the listbox. If the list is
		///                 empty, it doesn't show any listbox, working as questionYesNo.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Question").
		/// </param><param> name="buttonYes" The text for the first button.
		///                   The default is i18n("&Yes").
		/// </param><param> name="buttonNo" The text for the second button.
		///                   The default is i18n("&No").
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further confirmation can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Options
		/// </param> To be used for questions like "Do you really want to delete these files?"
		///  And show the user exactly which files are going to be deleted in case
		///  he presses "Yes"
		///  The default button is "No". Pressing "Esc" selects "No".
		///   </remarks>		<return> 'Yes' is returned if the Yes-button is pressed. 'No' is returned
		///           if the No-button is pressed.
		/// </return>
		/// 		<short>    Display a "warning" dialog with a listbox to show information to the user </short>
		public static int WarningYesNoList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningYesNoList#$?$##$$", "warningYesNoList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningYesNoList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningYesNoList#$?$##$", "warningYesNoList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName);
		}
		public static int WarningYesNoList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("warningYesNoList#$?$##", "warningYesNoList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int WarningYesNoList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("warningYesNoList#$?$#", "warningYesNoList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int WarningYesNoList(QWidget parent, string text, List<string> strlist, string caption) {
			return (int) staticInterceptor.Invoke("warningYesNoList#$?$", "warningYesNoList(QWidget*, const QString&, const QStringList&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static int WarningYesNoList(QWidget parent, string text, List<string> strlist) {
			return (int) staticInterceptor.Invoke("warningYesNoList#$?", "warningYesNoList(QWidget*, const QString&, const QStringList&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int WarningYesNoListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningYesNoListWId$$?$##$$", "warningYesNoListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningYesNoListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningYesNoListWId$$?$##$", "warningYesNoListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(string), dontAskAgainName);
		}
		public static int WarningYesNoListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("warningYesNoListWId$$?$##", "warningYesNoListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int WarningYesNoListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("warningYesNoListWId$$?$#", "warningYesNoListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int WarningYesNoListWId(uint parent_id, string text, List<string> strlist, string caption) {
			return (int) staticInterceptor.Invoke("warningYesNoListWId$$?$", "warningYesNoListWId(WId, const QString&, const QStringList&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static int WarningYesNoListWId(uint parent_id, string text, List<string> strlist) {
			return (int) staticInterceptor.Invoke("warningYesNoListWId$$?", "warningYesNoListWId(WId, const QString&, const QStringList&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  Display a "warning" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Warning").
		/// </param><param> name="buttonContinue" The text for the first button.
		/// </param><param> name="buttonCancel" The text for the second button.
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further confirmation can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Options
		/// </param> To be used for questions like "You are about to Print. Are you sure?"
		///  the continueButton should then be labeled "Print".
		///  The default button is buttonContinue. Pressing "Esc" selects "Cancel".
		///   </remarks>		<return> <code>Continue</code> is returned if the Continue-button is pressed.
		///           <code>Cancel</code> is returned if the Cancel-button is pressed.
		/// </return>
		/// 		<short>    Display a "warning" dialog.</short>
		public static int WarningContinueCancel(QWidget parent, string text, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningContinueCancel#$$##$$", "warningContinueCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningContinueCancel(QWidget parent, string text, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningContinueCancel#$$##$", "warningContinueCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int WarningContinueCancel(QWidget parent, string text, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("warningContinueCancel#$$##", "warningContinueCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel);
		}
		public static int WarningContinueCancel(QWidget parent, string text, string caption, KGuiItem buttonContinue) {
			return (int) staticInterceptor.Invoke("warningContinueCancel#$$#", "warningContinueCancel(QWidget*, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonContinue);
		}
		public static int WarningContinueCancel(QWidget parent, string text, string caption) {
			return (int) staticInterceptor.Invoke("warningContinueCancel#$$", "warningContinueCancel(QWidget*, const QString&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static int WarningContinueCancel(QWidget parent, string text) {
			return (int) staticInterceptor.Invoke("warningContinueCancel#$", "warningContinueCancel(QWidget*, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int WarningContinueCancelWId(uint parent_id, string text, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningContinueCancelWId$$$##$$", "warningContinueCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningContinueCancelWId(uint parent_id, string text, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningContinueCancelWId$$$##$", "warningContinueCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int WarningContinueCancelWId(uint parent_id, string text, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("warningContinueCancelWId$$$##", "warningContinueCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel);
		}
		public static int WarningContinueCancelWId(uint parent_id, string text, string caption, KGuiItem buttonContinue) {
			return (int) staticInterceptor.Invoke("warningContinueCancelWId$$$#", "warningContinueCancelWId(WId, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonContinue);
		}
		public static int WarningContinueCancelWId(uint parent_id, string text, string caption) {
			return (int) staticInterceptor.Invoke("warningContinueCancelWId$$$", "warningContinueCancelWId(WId, const QString&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption);
		}
		public static int WarningContinueCancelWId(uint parent_id, string text) {
			return (int) staticInterceptor.Invoke("warningContinueCancelWId$$", "warningContinueCancelWId(WId, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text);
		}
		/// <remarks>
		///  Display a "warning" dialog with a listbox to show information to the user.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="strlist" List of strings to be written in the listbox. If the
		///                 list is empty, it doesn't show any listbox, working
		///                 as warningContinueCancel.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Warning").
		/// </param><param> name="buttonContinue" The text for the first button.
		/// </param><param> name="buttonCancel" The text for the second button.
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further confirmation can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Options
		/// </param> To be used for questions like "You are about to Print. Are you sure?"
		///  the continueButton should then be labeled "Print".
		///  The default button is buttonContinue. Pressing "Esc" selects "Cancel".
		///   </remarks>		<return> <code>Continue</code> is returned if the Continue-button is pressed.
		///           <code>Cancel</code> is returned if the Cancel-button is pressed.
		/// </return>
		/// 		<short>    Display a "warning" dialog with a listbox to show information to the user.</short>
		public static int WarningContinueCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningContinueCancelList#$?$##$$", "warningContinueCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningContinueCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningContinueCancelList#$?$##$", "warningContinueCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int WarningContinueCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("warningContinueCancelList#$?$##", "warningContinueCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel);
		}
		public static int WarningContinueCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonContinue) {
			return (int) staticInterceptor.Invoke("warningContinueCancelList#$?$#", "warningContinueCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonContinue);
		}
		public static int WarningContinueCancelList(QWidget parent, string text, List<string> strlist, string caption) {
			return (int) staticInterceptor.Invoke("warningContinueCancelList#$?$", "warningContinueCancelList(QWidget*, const QString&, const QStringList&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static int WarningContinueCancelList(QWidget parent, string text, List<string> strlist) {
			return (int) staticInterceptor.Invoke("warningContinueCancelList#$?", "warningContinueCancelList(QWidget*, const QString&, const QStringList&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int WarningContinueCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningContinueCancelListWId$$?$##$$", "warningContinueCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningContinueCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningContinueCancelListWId$$?$##$", "warningContinueCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int WarningContinueCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonContinue, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("warningContinueCancelListWId$$?$##", "warningContinueCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonContinue, typeof(KGuiItem), buttonCancel);
		}
		public static int WarningContinueCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonContinue) {
			return (int) staticInterceptor.Invoke("warningContinueCancelListWId$$?$#", "warningContinueCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonContinue);
		}
		public static int WarningContinueCancelListWId(uint parent_id, string text, List<string> strlist, string caption) {
			return (int) staticInterceptor.Invoke("warningContinueCancelListWId$$?$", "warningContinueCancelListWId(WId, const QString&, const QStringList&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static int WarningContinueCancelListWId(uint parent_id, string text, List<string> strlist) {
			return (int) staticInterceptor.Invoke("warningContinueCancelListWId$$?", "warningContinueCancelListWId(WId, const QString&, const QStringList&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  Display a Yes/No/Cancel "warning" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Warning").
		/// </param><param> name="buttonYes" The text for the first button.
		///                   The default is i18n("&Yes").
		/// </param><param> name="buttonNo" The text for the second button.
		///                   The default is i18n("&No").
		/// </param><param> name="buttonCancel" The text for the third button.
		///                   The default is i18n("&Cancel").
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further questions can be turned off. If turned off
		///                 all questions will be automatically answered with the
		///                 last answer (either Yes or No).
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Options
		/// </param> To be used for questions "Do you want to save your changes?"
		///  The text should explain the implication of choosing 'No'.
		///  The default button is "Yes". Pressing "Esc" selects "Cancel"
		///   </remarks>		<return> <code>Yes</code> is returned if the Yes-button is pressed. <code>No</code> is returned
		///           if the No-button is pressed. <code>Cancel</code> is retunred if the Cancel-
		///           button is pressed.
		/// </return>
		/// 		<short>    Display a Yes/No/Cancel "warning" dialog.</short>
		public static int WarningYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningYesNoCancel#$$###$$", "warningYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningYesNoCancel#$$###$", "warningYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int WarningYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("warningYesNoCancel#$$###", "warningYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel);
		}
		public static int WarningYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("warningYesNoCancel#$$##", "warningYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int WarningYesNoCancel(QWidget parent, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("warningYesNoCancel#$$#", "warningYesNoCancel(QWidget*, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int WarningYesNoCancel(QWidget parent, string text, string caption) {
			return (int) staticInterceptor.Invoke("warningYesNoCancel#$$", "warningYesNoCancel(QWidget*, const QString&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static int WarningYesNoCancel(QWidget parent, string text) {
			return (int) staticInterceptor.Invoke("warningYesNoCancel#$", "warningYesNoCancel(QWidget*, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int WarningYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelWId$$$###$$", "warningYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelWId$$$###$", "warningYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int WarningYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelWId$$$###", "warningYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel);
		}
		public static int WarningYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelWId$$$##", "warningYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int WarningYesNoCancelWId(uint parent_id, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelWId$$$#", "warningYesNoCancelWId(WId, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int WarningYesNoCancelWId(uint parent_id, string text, string caption) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelWId$$$", "warningYesNoCancelWId(WId, const QString&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(string), caption);
		}
		public static int WarningYesNoCancelWId(uint parent_id, string text) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelWId$$", "warningYesNoCancelWId(WId, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text);
		}
		/// <remarks>
		///  Display a Yes/No/Cancel "warning" dialog with a listbox to show information
		///  to the user.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="strlist" List of strings to be written in the listbox. If the
		///                 list is empty, it doesn't show any listbox, working
		///                 as warningYesNoCancel.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Warning").
		/// </param><param> name="buttonYes" The text for the first button.
		///                   The default is i18n("&Yes").
		/// </param><param> name="buttonNo" The text for the second button.
		///                   The default is i18n("&No").
		/// </param><param> name="buttonCancel" The text for the third button.
		///                   The default is i18n("&Cancel").
		/// </param><param> name="dontAskAgainName" If provided, a checkbox is added with which
		///                 further questions can be turned off. If turned off
		///                 all questions will be automatically answered with the
		///                 last answer (either Yes or No).
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		///                 If <code>dontAskAgainName</code> starts with a ':' then the setting
		///                 is stored in the global config file.
		/// </param><param> name="options" see Options
		/// </param> To be used for questions "Do you want to save your changes?"
		///  The text should explain the implication of choosing 'No'.
		///  The default button is "Yes". Pressing "Esc" selects "Cancel"
		///   </remarks>		<return> <code>Yes</code> is returned if the Yes-button is pressed. <code>No</code> is returned
		///           if the No-button is pressed. <code>Cancel</code> is retunred if the Cancel-
		///           button is pressed.
		/// </return>
		/// 		<short>    Display a Yes/No/Cancel "warning" dialog with a listbox to show information  to the user.</short>
		public static int WarningYesNoCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelList#$?$###$$", "warningYesNoCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningYesNoCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelList#$?$###$", "warningYesNoCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int WarningYesNoCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelList#$?$###", "warningYesNoCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel);
		}
		public static int WarningYesNoCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelList#$?$##", "warningYesNoCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int WarningYesNoCancelList(QWidget parent, string text, List<string> strlist, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelList#$?$#", "warningYesNoCancelList(QWidget*, const QString&, const QStringList&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int WarningYesNoCancelList(QWidget parent, string text, List<string> strlist, string caption) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelList#$?$", "warningYesNoCancelList(QWidget*, const QString&, const QStringList&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static int WarningYesNoCancelList(QWidget parent, string text, List<string> strlist) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelList#$?", "warningYesNoCancelList(QWidget*, const QString&, const QStringList&)", typeof(int), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int WarningYesNoCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelListWId$$?$###$$", "warningYesNoCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName, typeof(uint), options);
		}
		public static int WarningYesNoCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontAskAgainName) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelListWId$$?$###$", "warningYesNoCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontAskAgainName);
		}
		public static int WarningYesNoCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelListWId$$?$###", "warningYesNoCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel);
		}
		public static int WarningYesNoCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelListWId$$?$##", "warningYesNoCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int WarningYesNoCancelListWId(uint parent_id, string text, List<string> strlist, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelListWId$$?$#", "warningYesNoCancelListWId(WId, const QString&, const QStringList&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int WarningYesNoCancelListWId(uint parent_id, string text, List<string> strlist, string caption) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelListWId$$?$", "warningYesNoCancelListWId(WId, const QString&, const QStringList&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static int WarningYesNoCancelListWId(uint parent_id, string text, List<string> strlist) {
			return (int) staticInterceptor.Invoke("warningYesNoCancelListWId$$?", "warningYesNoCancelListWId(WId, const QString&, const QStringList&)", typeof(int), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  Display an "Error" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Error").
		/// </param><param> name="options" see Options
		/// </param> Your program messed up and now it's time to inform the user.
		///  To be used for important things like "Sorry, I deleted your hard disk."
		///  If your program detects the action specified by the user is somehow
		///  not allowed, this should never be reported with error(). Use sorry()
		///  instead to explain to the user that this action is not allowed.
		///  The default button is "&OK". Pressing "Esc" selects the OK-button.
		///  NOTE: The OK button will always have the i18n'ed text '&OK'.
		///   </remarks>		<short>    Display an "Error" dialog.</short>
		public static void Error(QWidget parent, string text, string caption, uint options) {
			staticInterceptor.Invoke("error#$$$", "error(QWidget*, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(uint), options);
		}
		public static void Error(QWidget parent, string text, string caption) {
			staticInterceptor.Invoke("error#$$", "error(QWidget*, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static void Error(QWidget parent, string text) {
			staticInterceptor.Invoke("error#$", "error(QWidget*, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void ErrorWId(uint parent_id, string text, string caption, uint options) {
			staticInterceptor.Invoke("errorWId$$$$", "errorWId(WId, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(uint), options);
		}
		public static void ErrorWId(uint parent_id, string text, string caption) {
			staticInterceptor.Invoke("errorWId$$$", "errorWId(WId, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), caption);
		}
		public static void ErrorWId(uint parent_id, string text) {
			staticInterceptor.Invoke("errorWId$$", "errorWId(WId, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text);
		}
		/// <remarks>
		///  Display an "Error" dialog with a listbox.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="strlist" List of strings to be written in the listbox. If the
		///                 list is empty, it doesn't show any listbox, working
		///                 as error().
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Error").
		/// </param><param> name="options" see Options
		/// </param> Your program messed up and now it's time to inform the user.
		///  To be used for important things like "Sorry, I deleted your hard disk."
		///  If your program detects the action specified by the user is somehow
		///  not allowed, this should never be reported with error(). Use sorry()
		///  instead to explain to the user that this action is not allowed.
		///  The default button is "&OK". Pressing "Esc" selects the OK-button.
		///  NOTE: The OK button will always have the i18n'ed text '&OK'.
		///   </remarks>		<short>    Display an "Error" dialog with a listbox.</short>
		public static void ErrorList(QWidget parent, string text, List<string> strlist, string caption, uint options) {
			staticInterceptor.Invoke("errorList#$?$$", "errorList(QWidget*, const QString&, const QStringList&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(uint), options);
		}
		public static void ErrorList(QWidget parent, string text, List<string> strlist, string caption) {
			staticInterceptor.Invoke("errorList#$?$", "errorList(QWidget*, const QString&, const QStringList&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static void ErrorList(QWidget parent, string text, List<string> strlist) {
			staticInterceptor.Invoke("errorList#$?", "errorList(QWidget*, const QString&, const QStringList&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void ErrorListWId(uint parent_id, string text, List<string> strlist, string caption, uint options) {
			staticInterceptor.Invoke("errorListWId$$?$$", "errorListWId(WId, const QString&, const QStringList&, const QString&, KMessageBox::Options)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(uint), options);
		}
		public static void ErrorListWId(uint parent_id, string text, List<string> strlist, string caption) {
			staticInterceptor.Invoke("errorListWId$$?$", "errorListWId(WId, const QString&, const QStringList&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static void ErrorListWId(uint parent_id, string text, List<string> strlist) {
			staticInterceptor.Invoke("errorListWId$$?", "errorListWId(WId, const QString&, const QStringList&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  Displays an "Error" dialog with a "Details >>" button.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="details" Detailed message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Error").
		/// </param><param> name="options" see Options
		/// </param> Your program messed up and now it's time to inform the user.
		///  To be used for important things like "Sorry, I deleted your hard disk."
		///  The <code>details</code> message can conatin additional information about
		///  the problem and can be shown on request to advanced/interested users.
		///  If your program detects the action specified by the user is somehow
		///  not allowed, this should never be reported with error(). Use sorry()
		///  instead to explain to the user that this action is not allowed.
		///  The default button is "&OK". Pressing "Esc" selects the OK-button.
		///  NOTE: The OK button will always have the i18n'ed text '&OK'.
		///   </remarks>		<short>    Displays an "Error" dialog with a "Details >>" button.</short>
		public static void DetailedError(QWidget parent, string text, string details, string caption, uint options) {
			staticInterceptor.Invoke("detailedError#$$$$", "detailedError(QWidget*, const QString&, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), details, typeof(string), caption, typeof(uint), options);
		}
		public static void DetailedError(QWidget parent, string text, string details, string caption) {
			staticInterceptor.Invoke("detailedError#$$$", "detailedError(QWidget*, const QString&, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), details, typeof(string), caption);
		}
		public static void DetailedError(QWidget parent, string text, string details) {
			staticInterceptor.Invoke("detailedError#$$", "detailedError(QWidget*, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), details);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void DetailedErrorWId(uint parent_id, string text, string details, string caption, uint options) {
			staticInterceptor.Invoke("detailedErrorWId$$$$$", "detailedErrorWId(WId, const QString&, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), details, typeof(string), caption, typeof(uint), options);
		}
		public static void DetailedErrorWId(uint parent_id, string text, string details, string caption) {
			staticInterceptor.Invoke("detailedErrorWId$$$$", "detailedErrorWId(WId, const QString&, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), details, typeof(string), caption);
		}
		public static void DetailedErrorWId(uint parent_id, string text, string details) {
			staticInterceptor.Invoke("detailedErrorWId$$$", "detailedErrorWId(WId, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), details);
		}
		/// <remarks>
		///  Like detailedError
		///  This function will return immediately, the messagebox will be shown
		///  once the application enters an event loop and no other messagebox
		///  is being shown.
		///  Note that if the parent gets deleted, the messagebox will not be
		///  shown.
		///    </remarks>		<short>    Like detailedError </short>
		public static void QueuedDetailedError(QWidget parent, string text, string details, string caption) {
			staticInterceptor.Invoke("queuedDetailedError#$$$", "queuedDetailedError(QWidget*, const QString&, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), details, typeof(string), caption);
		}
		public static void QueuedDetailedError(QWidget parent, string text, string details) {
			staticInterceptor.Invoke("queuedDetailedError#$$", "queuedDetailedError(QWidget*, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), details);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void QueuedDetailedErrorWId(uint parent_id, string text, string details, string caption) {
			staticInterceptor.Invoke("queuedDetailedErrorWId$$$$", "queuedDetailedErrorWId(WId, const QString&, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), details, typeof(string), caption);
		}
		public static void QueuedDetailedErrorWId(uint parent_id, string text, string details) {
			staticInterceptor.Invoke("queuedDetailedErrorWId$$$", "queuedDetailedErrorWId(WId, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), details);
		}
		/// <remarks>
		///  Display an "Sorry" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Sorry").
		/// </param><param> name="options" see OptionsType
		/// </param> Either your program messed up and asks for understanding
		///  or your user did something stupid.
		///  To be used for small problems like
		///  "Sorry, I can't find the file you specified."
		///  The default button is "&OK". Pressing "Esc" selects the OK-button.
		///  NOTE: The ok button will always have the i18n'ed text '&OK'.
		///   </remarks>		<short>    Display an "Sorry" dialog.</short>
		public static void Sorry(QWidget parent, string text, string caption, uint options) {
			staticInterceptor.Invoke("sorry#$$$", "sorry(QWidget*, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(uint), options);
		}
		public static void Sorry(QWidget parent, string text, string caption) {
			staticInterceptor.Invoke("sorry#$$", "sorry(QWidget*, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static void Sorry(QWidget parent, string text) {
			staticInterceptor.Invoke("sorry#$", "sorry(QWidget*, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void SorryWId(uint parent_id, string text, string caption, uint options) {
			staticInterceptor.Invoke("sorryWId$$$$", "sorryWId(WId, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(uint), options);
		}
		public static void SorryWId(uint parent_id, string text, string caption) {
			staticInterceptor.Invoke("sorryWId$$$", "sorryWId(WId, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), caption);
		}
		public static void SorryWId(uint parent_id, string text) {
			staticInterceptor.Invoke("sorryWId$$", "sorryWId(WId, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text);
		}
		/// <remarks>
		///  Displays a "Sorry" dialog with a "Details >>" button.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="details" Detailed message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Sorry").
		/// </param><param> name="options" see Options
		/// </param> Either your program messed up and asks for understanding
		///  or your user did something stupid.
		///  To be used for small problems like
		///  "Sorry, I can't find the file you specified."
		///  And then <code>details</code> can contain something like
		///  "foobar.txt was not found in any of
		///   the following directories:
		///   /usr/bin,/usr/local/bin,/usr/sbin"
		///  The default button is "&OK". Pressing "Esc" selects the OK-button.
		///  NOTE: The ok button will always have the i18n'ed text '&OK'.
		///   </remarks>		<short>    Displays a "Sorry" dialog with a "Details >>" button.</short>
		public static void DetailedSorry(QWidget parent, string text, string details, string caption, uint options) {
			staticInterceptor.Invoke("detailedSorry#$$$$", "detailedSorry(QWidget*, const QString&, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), details, typeof(string), caption, typeof(uint), options);
		}
		public static void DetailedSorry(QWidget parent, string text, string details, string caption) {
			staticInterceptor.Invoke("detailedSorry#$$$", "detailedSorry(QWidget*, const QString&, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), details, typeof(string), caption);
		}
		public static void DetailedSorry(QWidget parent, string text, string details) {
			staticInterceptor.Invoke("detailedSorry#$$", "detailedSorry(QWidget*, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), details);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void DetailedSorryWId(uint parent_id, string text, string details, string caption, uint options) {
			staticInterceptor.Invoke("detailedSorryWId$$$$$", "detailedSorryWId(WId, const QString&, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), details, typeof(string), caption, typeof(uint), options);
		}
		public static void DetailedSorryWId(uint parent_id, string text, string details, string caption) {
			staticInterceptor.Invoke("detailedSorryWId$$$$", "detailedSorryWId(WId, const QString&, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), details, typeof(string), caption);
		}
		public static void DetailedSorryWId(uint parent_id, string text, string details) {
			staticInterceptor.Invoke("detailedSorryWId$$$", "detailedSorryWId(WId, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), details);
		}
		/// <remarks>
		///  Display an "Information" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Information").
		/// </param><param> name="dontShowAgainName" If provided, a checkbox is added with which
		///                 further notifications can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		/// </param><param> name="options" see Options
		/// </param> Your program wants to tell the user something.
		///  To be used for things like:
		///  "Your bookmarks have been rearranged."
		///  The default button is "&OK". Pressing "Esc" selects the OK-button.
		///   NOTE: The OK button will always have the i18n'ed text '&OK'.
		///   </remarks>		<short>    Display an "Information" dialog.</short>
		public static void Information(QWidget parent, string text, string caption, string dontShowAgainName, uint options) {
			staticInterceptor.Invoke("information#$$$$", "information(QWidget*, const QString&, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(string), dontShowAgainName, typeof(uint), options);
		}
		public static void Information(QWidget parent, string text, string caption, string dontShowAgainName) {
			staticInterceptor.Invoke("information#$$$", "information(QWidget*, const QString&, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(string), dontShowAgainName);
		}
		public static void Information(QWidget parent, string text, string caption) {
			staticInterceptor.Invoke("information#$$", "information(QWidget*, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static void Information(QWidget parent, string text) {
			staticInterceptor.Invoke("information#$", "information(QWidget*, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void InformationWId(uint parent_id, string text, string caption, string dontShowAgainName, uint options) {
			staticInterceptor.Invoke("informationWId$$$$$", "informationWId(WId, const QString&, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(string), dontShowAgainName, typeof(uint), options);
		}
		public static void InformationWId(uint parent_id, string text, string caption, string dontShowAgainName) {
			staticInterceptor.Invoke("informationWId$$$$", "informationWId(WId, const QString&, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), caption, typeof(string), dontShowAgainName);
		}
		public static void InformationWId(uint parent_id, string text, string caption) {
			staticInterceptor.Invoke("informationWId$$$", "informationWId(WId, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(string), caption);
		}
		public static void InformationWId(uint parent_id, string text) {
			staticInterceptor.Invoke("informationWId$$", "informationWId(WId, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text);
		}
		/// <remarks>
		///  Display an "Information" dialog with a listbox.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="strlist" List of strings to be written in the listbox. If the
		///                 list is empty, it doesn't show any listbox, working
		///                 as information.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("Information").
		/// </param><param> name="dontShowAgainName" If provided, a checkbox is added with which
		///                 further notifications can be turned off.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		///                 The setting is stored in the "Notification Messages" group.
		/// </param><param> name="options" see Options
		/// </param> Your program wants to tell the user something.
		///  To be used for things like:
		///  "The following bookmarks have been rearranged:"
		///  The default button is "&OK". Pressing "Esc" selects the OK-button.
		///   NOTE: The OK button will always have the i18n'ed text '&OK'.
		///   </remarks>		<short>    Display an "Information" dialog with a listbox.</short>
		public static void InformationList(QWidget parent, string text, List<string> strlist, string caption, string dontShowAgainName, uint options) {
			staticInterceptor.Invoke("informationList#$?$$$", "informationList(QWidget*, const QString&, const QStringList&, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(string), dontShowAgainName, typeof(uint), options);
		}
		public static void InformationList(QWidget parent, string text, List<string> strlist, string caption, string dontShowAgainName) {
			staticInterceptor.Invoke("informationList#$?$$", "informationList(QWidget*, const QString&, const QStringList&, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(string), dontShowAgainName);
		}
		public static void InformationList(QWidget parent, string text, List<string> strlist, string caption) {
			staticInterceptor.Invoke("informationList#$?$", "informationList(QWidget*, const QString&, const QStringList&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static void InformationList(QWidget parent, string text, List<string> strlist) {
			staticInterceptor.Invoke("informationList#$?", "informationList(QWidget*, const QString&, const QStringList&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///   </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void InformationListWId(uint parent_id, string text, List<string> strlist, string caption, string dontShowAgainName, uint options) {
			staticInterceptor.Invoke("informationListWId$$?$$$", "informationListWId(WId, const QString&, const QStringList&, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(string), dontShowAgainName, typeof(uint), options);
		}
		public static void InformationListWId(uint parent_id, string text, List<string> strlist, string caption, string dontShowAgainName) {
			staticInterceptor.Invoke("informationListWId$$?$$", "informationListWId(WId, const QString&, const QStringList&, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption, typeof(string), dontShowAgainName);
		}
		public static void InformationListWId(uint parent_id, string text, List<string> strlist, string caption) {
			staticInterceptor.Invoke("informationListWId$$?$", "informationListWId(WId, const QString&, const QStringList&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist, typeof(string), caption);
		}
		public static void InformationListWId(uint parent_id, string text, List<string> strlist) {
			staticInterceptor.Invoke("informationListWId$$?", "informationListWId(WId, const QString&, const QStringList&)", typeof(void), typeof(uint), parent_id, typeof(string), text, typeof(List<string>), strlist);
		}
		/// <remarks>
		///  Enable all messages which have been turned off with the
		///  <code>dontShowAgainName</code> feature.
		///    </remarks>		<short>    Enable all messages which have been turned off with the  <code>dontShowAgainName</code> feature.</short>
		public static void EnableAllMessages() {
			staticInterceptor.Invoke("enableAllMessages", "enableAllMessages()", typeof(void));
		}
		/// <remarks>
		///  Re-enable a specific <code>dontShowAgainName</code> messages that had 
		///  previously been turned off.
		/// </remarks>		<short>    Re-enable a specific <code>dontShowAgainName</code> messages that had   previously been turned off.</short>
		/// 		<see> saveDontShowAgainYesNo</see>
		/// 		<see> saveDontShowAgainContinue</see>
		public static void EnableMessage(string dontShowAgainName) {
			staticInterceptor.Invoke("enableMessage$", "enableMessage(const QString&)", typeof(void), typeof(string), dontShowAgainName);
		}
		/// <remarks>
		///  Display an "About" dialog.
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title. The application name is added to
		///                 the title. The default title is i18n("About \<appname\>").
		/// </param><param> name="options" see Options
		/// </param> Your program wants to show some general information about the application
		///  like the authors's names and email addresses.
		///  The default button is "&OK".
		///   NOTE: The ok button will always have the i18n'ed text '&OK'.
		///    </remarks>		<short>    Display an "About" dialog.</short>
		public static void About(QWidget parent, string text, string caption, uint options) {
			staticInterceptor.Invoke("about#$$$", "about(QWidget*, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption, typeof(uint), options);
		}
		public static void About(QWidget parent, string text, string caption) {
			staticInterceptor.Invoke("about#$$", "about(QWidget*, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text, typeof(string), caption);
		}
		public static void About(QWidget parent, string text) {
			staticInterceptor.Invoke("about#$", "about(QWidget*, const QString&)", typeof(void), typeof(QWidget), parent, typeof(string), text);
		}
		/// <remarks>
		///  Alternate method to show a messagebox:
		/// <param> name="parent" If <code>parent</code> is 0, then the message box becomes an
		///                 application-global modal dialog box. If <code>parent</code> is a
		///                 widget, the message box becomes modal relative to parent.
		/// </param><param> name="type" type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
		/// </param><param> name="text" Message string.
		/// </param><param> name="caption" Message box title.
		/// </param><param> name="buttonYes" The text for the first button.
		///                   The default is i18n("&Yes").
		/// </param><param> name="buttonNo" The text for the second button.
		///                   The default is i18n("&No").
		/// </param><param> name="buttonCancel" The text for the third button.
		///                   The default is i18n("&Cancel").
		/// </param><param> name="dontShowAskAgainName" If provided, a checkbox is added with which
		///                 further questions/information can be turned off. If turned off
		///                 all questions will be automatically answered with the
		///                 last answer (either Yes or No), if the message box needs an answer.
		///                 The string is used to lookup and store the setting
		///                 in the applications config file.
		/// </param><param> name="options" see Options
		///  Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
		///        and for Information, none is used.
		/// </param></remarks>		<return> a button code, as defined in KMessageBox.
		///      </return>
		/// 		<short>    Alternate method to show a messagebox: </short>
		public static int MessageBox(QWidget parent, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontShowAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("messageBox#$$$###$$", "messageBox(QWidget*, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontShowAskAgainName, typeof(uint), options);
		}
		public static int MessageBox(QWidget parent, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontShowAskAgainName) {
			return (int) staticInterceptor.Invoke("messageBox#$$$###$", "messageBox(QWidget*, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontShowAskAgainName);
		}
		public static int MessageBox(QWidget parent, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("messageBox#$$$###", "messageBox(QWidget*, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel);
		}
		public static int MessageBox(QWidget parent, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("messageBox#$$$##", "messageBox(QWidget*, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int MessageBox(QWidget parent, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("messageBox#$$$#", "messageBox(QWidget*, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int MessageBox(QWidget parent, KMessageBox.DialogType type, string text, string caption) {
			return (int) staticInterceptor.Invoke("messageBox#$$$", "messageBox(QWidget*, KMessageBox::DialogType, const QString&, const QString&)", typeof(int), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption);
		}
		public static int MessageBox(QWidget parent, KMessageBox.DialogType type, string text) {
			return (int) staticInterceptor.Invoke("messageBox#$$", "messageBox(QWidget*, KMessageBox::DialogType, const QString&)", typeof(int), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///      </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static int MessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontShowAskAgainName, uint options) {
			return (int) staticInterceptor.Invoke("messageBoxWId$$$$###$$", "messageBoxWId(WId, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&, KMessageBox::Options)", typeof(int), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontShowAskAgainName, typeof(uint), options);
		}
		public static int MessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel, string dontShowAskAgainName) {
			return (int) staticInterceptor.Invoke("messageBoxWId$$$$###$", "messageBoxWId(WId, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel, typeof(string), dontShowAskAgainName);
		}
		public static int MessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo, KGuiItem buttonCancel) {
			return (int) staticInterceptor.Invoke("messageBoxWId$$$$###", "messageBoxWId(WId, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo, typeof(KGuiItem), buttonCancel);
		}
		public static int MessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes, KGuiItem buttonNo) {
			return (int) staticInterceptor.Invoke("messageBoxWId$$$$##", "messageBoxWId(WId, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes, typeof(KGuiItem), buttonNo);
		}
		public static int MessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text, string caption, KGuiItem buttonYes) {
			return (int) staticInterceptor.Invoke("messageBoxWId$$$$#", "messageBoxWId(WId, KMessageBox::DialogType, const QString&, const QString&, const KGuiItem&)", typeof(int), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(KGuiItem), buttonYes);
		}
		public static int MessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text, string caption) {
			return (int) staticInterceptor.Invoke("messageBoxWId$$$$", "messageBoxWId(WId, KMessageBox::DialogType, const QString&, const QString&)", typeof(int), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption);
		}
		public static int MessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text) {
			return (int) staticInterceptor.Invoke("messageBoxWId$$$", "messageBoxWId(WId, KMessageBox::DialogType, const QString&)", typeof(int), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text);
		}
		/// <remarks>
		///  Like messageBox
		///  Only for message boxes of type Information, Sorry or Error.
		///  This function will return immediately, the messagebox will be shown
		///  once the application enters an event loop and no other messagebox
		///  is being shown.
		///  Note that if the parent gets deleted, the messagebox will not be
		///  shown.
		///      </remarks>		<short>    Like messageBox </short>
		public static void QueuedMessageBox(QWidget parent, KMessageBox.DialogType type, string text, string caption, uint options) {
			staticInterceptor.Invoke("queuedMessageBox#$$$$", "queuedMessageBox(QWidget*, KMessageBox::DialogType, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(uint), options);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///      </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void QueuedMessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text, string caption, uint options) {
			staticInterceptor.Invoke("queuedMessageBoxWId$$$$$", "queuedMessageBoxWId(WId, KMessageBox::DialogType, const QString&, const QString&, KMessageBox::Options)", typeof(void), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption, typeof(uint), options);
		}
		/// <remarks>
		///  @overload
		///  This is an overloaded member function, provided for convenience.
		///  It behaves essentially like the above function.
		///      </remarks>		<short>    @overload </short>
		public static void QueuedMessageBox(QWidget parent, KMessageBox.DialogType type, string text, string caption) {
			staticInterceptor.Invoke("queuedMessageBox#$$$", "queuedMessageBox(QWidget*, KMessageBox::DialogType, const QString&, const QString&)", typeof(void), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption);
		}
		public static void QueuedMessageBox(QWidget parent, KMessageBox.DialogType type, string text) {
			staticInterceptor.Invoke("queuedMessageBox#$$", "queuedMessageBox(QWidget*, KMessageBox::DialogType, const QString&)", typeof(void), typeof(QWidget), parent, typeof(KMessageBox.DialogType), type, typeof(string), text);
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///      </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static void QueuedMessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text, string caption) {
			staticInterceptor.Invoke("queuedMessageBoxWId$$$$", "queuedMessageBoxWId(WId, KMessageBox::DialogType, const QString&, const QString&)", typeof(void), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text, typeof(string), caption);
		}
		public static void QueuedMessageBoxWId(uint parent_id, KMessageBox.DialogType type, string text) {
			staticInterceptor.Invoke("queuedMessageBoxWId$$$", "queuedMessageBoxWId(WId, KMessageBox::DialogType, const QString&)", typeof(void), typeof(uint), parent_id, typeof(KMessageBox.DialogType), type, typeof(string), text);
		}
		/// <remarks>
		/// <param> name="dontShowAgainName" the name that identify the message box. If
		///  empty, true is always returned.
		/// </param><param> name="result" is set to the result (Yes or No) that was chosen the last
		///  time the message box was shown. Only meaningful, if the message box
		///  should not be shown.
		///      </param></remarks>		<return> true if the corresponding yes/no message box should be shown.
		/// </return>
		/// 		<short>   </short>
		public static bool ShouldBeShownYesNo(string dontShowAgainName, KMessageBox.ButtonCode result) {
			return (bool) staticInterceptor.Invoke("shouldBeShownYesNo$$", "shouldBeShownYesNo(const QString&, KMessageBox::ButtonCode&)", typeof(bool), typeof(string), dontShowAgainName, typeof(KMessageBox.ButtonCode), result);
		}
		/// <remarks>
		/// <param> name="dontShowAgainName" the name that identify the message box. If
		///  empty, true is always returned.
		///      </param></remarks>		<return> true if the corresponding continue/cancel message box should be
		///  shown.
		/// </return>
		/// 		<short>   </short>
		public static bool ShouldBeShownContinue(string dontShowAgainName) {
			return (bool) staticInterceptor.Invoke("shouldBeShownContinue$", "shouldBeShownContinue(const QString&)", typeof(bool), typeof(string), dontShowAgainName);
		}
		/// <remarks>
		///  Save the fact that the yes/no message box should not be shown again.
		/// <param> name="dontShowAgainName" the name that identify the message box. If
		///  empty, this method does nothing.
		/// </param><param> name="result" the value (Yes or No) that should be used as the result
		///  for the message box.
		///      </param></remarks>		<short>    Save the fact that the yes/no message box should not be shown again.</short>
		public static void SaveDontShowAgainYesNo(string dontShowAgainName, KMessageBox.ButtonCode result) {
			staticInterceptor.Invoke("saveDontShowAgainYesNo$$", "saveDontShowAgainYesNo(const QString&, KMessageBox::ButtonCode)", typeof(void), typeof(string), dontShowAgainName, typeof(KMessageBox.ButtonCode), result);
		}
		/// <remarks>
		///  Save the fact that the continue/cancel message box should not be shown
		///  again.
		/// <param> name="dontShowAgainName" the name that identify the message box. If
		///  empty, this method does nothing.
		///      </param></remarks>		<short>    Save the fact that the continue/cancel message box should not be shown  again.</short>
		public static void SaveDontShowAgainContinue(string dontShowAgainName) {
			staticInterceptor.Invoke("saveDontShowAgainContinue$", "saveDontShowAgainContinue(const QString&)", typeof(void), typeof(string), dontShowAgainName);
		}
		/// <remarks>
		///  Use <code>cfg</code> for all settings related to the dontShowAgainName feature.
		///  If <code>cfg</code> is 0 (default) KGlobal.Config() will be used.
		///      </remarks>		<short>    Use <code>cfg</code> for all settings related to the dontShowAgainName feature.</short>
		public static void SetDontShowAskAgainConfig(KConfig cfg) {
			staticInterceptor.Invoke("setDontShowAskAgainConfig#", "setDontShowAskAgainConfig(KConfig*)", typeof(void), typeof(KConfig), cfg);
		}
		/// <remarks>
		///  Create content and layout of a standard dialog
		/// <param> name="dialog" The parent dialog base
		/// </param><param> name="icon" Which predefined icon the message box shall show.
		/// </param><param> name="text" Message string.
		/// </param><param> name="strlist" List of strings to be written in the listbox.
		///                 If the list is empty, it doesn't show any listbox
		/// </param><param> name="ask" The text of the checkbox. If empty none will be shown.
		/// </param><param> name="checkboxReturn" The result of the checkbox. If it's initially
		///                 true then the checkbox will be checked by default.
		/// </param><param> name="options" see Options
		/// </param><param> name="details" Detailed message string.
		/// </param></remarks>		<return> A KDialog button code, not a KMessageBox button code,
		///          based on the buttonmask given to the constructor of the
		///          <code>dialog</code> (ie. will return KDialog.Yes [256] instead of 
		///          KMessageBox.Yes [3]). Will return KMessageBox.Cancel
		///          if the message box is queued for display instead of 
		///          exec()ed immediately or if the option NoExec is set.
		///  @note   The <code>dialog</code> that is passed in is deleted by this
		///          function. Do not delete it yourself.
		///      </return>
		/// 		<short>    Create content and layout of a standard dialog </short>
		public static int CreateKMessageBox(KDialog dialog, QMessageBox.Icon icon, string text, List<string> strlist, string ask, ref bool checkboxReturn, uint options, string details) {
			StackItem[] stack = new StackItem[9];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(dialog);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(dialog);
#endif
			stack[2].s_int = (int) icon;
#if DEBUG
			stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(text);
#else
			stack[3].s_class = (IntPtr) GCHandle.Alloc(text);
#endif
#if DEBUG
			stack[4].s_class = (IntPtr) DebugGCHandle.Alloc(strlist);
#else
			stack[4].s_class = (IntPtr) GCHandle.Alloc(strlist);
#endif
#if DEBUG
			stack[5].s_class = (IntPtr) DebugGCHandle.Alloc(ask);
#else
			stack[5].s_class = (IntPtr) GCHandle.Alloc(ask);
#endif
			stack[6].s_bool = checkboxReturn;
			stack[7].s_uint = options;
#if DEBUG
			stack[8].s_class = (IntPtr) DebugGCHandle.Alloc(details);
#else
			stack[8].s_class = (IntPtr) GCHandle.Alloc(details);
#endif
			staticInterceptor.Invoke("createKMessageBox#$$?$$$$", "createKMessageBox(KDialog*, QMessageBox::Icon, const QString&, const QStringList&, const QString&, bool*, KMessageBox::Options, const QString&)", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
			((GCHandle) stack[3].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[4].s_class);
#else
			((GCHandle) stack[4].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[5].s_class);
#else
			((GCHandle) stack[5].s_class).Free();
#endif
			checkboxReturn = stack[6].s_bool;
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[8].s_class);
#else
			((GCHandle) stack[8].s_class).Free();
#endif
			return stack[0].s_int;
		}
		public static int CreateKMessageBox(KDialog dialog, QMessageBox.Icon icon, string text, List<string> strlist, string ask, ref bool checkboxReturn, uint options) {
			StackItem[] stack = new StackItem[8];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(dialog);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(dialog);
#endif
			stack[2].s_int = (int) icon;
#if DEBUG
			stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(text);
#else
			stack[3].s_class = (IntPtr) GCHandle.Alloc(text);
#endif
#if DEBUG
			stack[4].s_class = (IntPtr) DebugGCHandle.Alloc(strlist);
#else
			stack[4].s_class = (IntPtr) GCHandle.Alloc(strlist);
#endif
#if DEBUG
			stack[5].s_class = (IntPtr) DebugGCHandle.Alloc(ask);
#else
			stack[5].s_class = (IntPtr) GCHandle.Alloc(ask);
#endif
			stack[6].s_bool = checkboxReturn;
			stack[7].s_uint = options;
			staticInterceptor.Invoke("createKMessageBox#$$?$$$", "createKMessageBox(KDialog*, QMessageBox::Icon, const QString&, const QStringList&, const QString&, bool*, KMessageBox::Options)", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
			((GCHandle) stack[3].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[4].s_class);
#else
			((GCHandle) stack[4].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[5].s_class);
#else
			((GCHandle) stack[5].s_class).Free();
#endif
			checkboxReturn = stack[6].s_bool;
			return stack[0].s_int;
		}
		/// <remarks>
		///  Create content and layout of a standard dialog
		/// <param> name="dialog" The parent dialog base
		/// </param><param> name="icon" A QPixmap containing the icon to be displayed in the
		///                 dialog next to the text.
		/// </param><param> name="text" Message string.
		/// </param><param> name="strlist" List of strings to be written in the listbox.
		///                 If the list is empty, it doesn't show any listbox
		/// </param><param> name="ask" The text of the checkbox. If empty none will be shown.
		/// </param><param> name="checkboxReturn" The result of the checkbox. If it's initially
		///                 true then the checkbox will be checked by default.
		/// </param><param> name="options" see Options
		/// </param><param> name="details" Detailed message string.
		/// </param><param> name="notifyType" The type of notification to send when this message
		///                 is presentend.
		/// </param></remarks>		<return> A KDialog button code, not a KMessageBox button code,
		///          based on the buttonmask given to the constructor of the
		///          <code>dialog</code> (ie. will return KDialog.Yes [256] instead of 
		///          KMessageBox.Yes [3]). Will return KMessageBox.Cancel
		///          if the message box is queued for display instead of 
		///          exec()ed immediately or if the option NoExec is set.
		///  @note   The <code>dialog</code> that is passed in is deleted by this
		///          function. Do not delete it yourself.
		///      </return>
		/// 		<short>    Create content and layout of a standard dialog </short>
		public static int CreateKMessageBox(KDialog dialog, QIcon icon, string text, List<string> strlist, string ask, ref bool checkboxReturn, uint options, string details, QMessageBox.Icon notifyType) {
			StackItem[] stack = new StackItem[10];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(dialog);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(dialog);
#endif
#if DEBUG
			stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(icon);
#else
			stack[2].s_class = (IntPtr) GCHandle.Alloc(icon);
#endif
#if DEBUG
			stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(text);
#else
			stack[3].s_class = (IntPtr) GCHandle.Alloc(text);
#endif
#if DEBUG
			stack[4].s_class = (IntPtr) DebugGCHandle.Alloc(strlist);
#else
			stack[4].s_class = (IntPtr) GCHandle.Alloc(strlist);
#endif
#if DEBUG
			stack[5].s_class = (IntPtr) DebugGCHandle.Alloc(ask);
#else
			stack[5].s_class = (IntPtr) GCHandle.Alloc(ask);
#endif
			stack[6].s_bool = checkboxReturn;
			stack[7].s_uint = options;
#if DEBUG
			stack[8].s_class = (IntPtr) DebugGCHandle.Alloc(details);
#else
			stack[8].s_class = (IntPtr) GCHandle.Alloc(details);
#endif
			stack[9].s_int = (int) notifyType;
			staticInterceptor.Invoke("createKMessageBox##$?$$$$$", "createKMessageBox(KDialog*, const QIcon&, const QString&, const QStringList&, const QString&, bool*, KMessageBox::Options, const QString&, QMessageBox::Icon)", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
			((GCHandle) stack[2].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
			((GCHandle) stack[3].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[4].s_class);
#else
			((GCHandle) stack[4].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[5].s_class);
#else
			((GCHandle) stack[5].s_class).Free();
#endif
			checkboxReturn = stack[6].s_bool;
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[8].s_class);
#else
			((GCHandle) stack[8].s_class).Free();
#endif
			return stack[0].s_int;
		}
		public static int CreateKMessageBox(KDialog dialog, QIcon icon, string text, List<string> strlist, string ask, ref bool checkboxReturn, uint options, string details) {
			StackItem[] stack = new StackItem[9];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(dialog);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(dialog);
#endif
#if DEBUG
			stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(icon);
#else
			stack[2].s_class = (IntPtr) GCHandle.Alloc(icon);
#endif
#if DEBUG
			stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(text);
#else
			stack[3].s_class = (IntPtr) GCHandle.Alloc(text);
#endif
#if DEBUG
			stack[4].s_class = (IntPtr) DebugGCHandle.Alloc(strlist);
#else
			stack[4].s_class = (IntPtr) GCHandle.Alloc(strlist);
#endif
#if DEBUG
			stack[5].s_class = (IntPtr) DebugGCHandle.Alloc(ask);
#else
			stack[5].s_class = (IntPtr) GCHandle.Alloc(ask);
#endif
			stack[6].s_bool = checkboxReturn;
			stack[7].s_uint = options;
#if DEBUG
			stack[8].s_class = (IntPtr) DebugGCHandle.Alloc(details);
#else
			stack[8].s_class = (IntPtr) GCHandle.Alloc(details);
#endif
			staticInterceptor.Invoke("createKMessageBox##$?$$$$", "createKMessageBox(KDialog*, const QIcon&, const QString&, const QStringList&, const QString&, bool*, KMessageBox::Options, const QString&)", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
			((GCHandle) stack[2].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
			((GCHandle) stack[3].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[4].s_class);
#else
			((GCHandle) stack[4].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[5].s_class);
#else
			((GCHandle) stack[5].s_class).Free();
#endif
			checkboxReturn = stack[6].s_bool;
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[8].s_class);
#else
			((GCHandle) stack[8].s_class).Free();
#endif
			return stack[0].s_int;
		}
		public static int CreateKMessageBox(KDialog dialog, QIcon icon, string text, List<string> strlist, string ask, ref bool checkboxReturn, uint options) {
			StackItem[] stack = new StackItem[8];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(dialog);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(dialog);
#endif
#if DEBUG
			stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(icon);
#else
			stack[2].s_class = (IntPtr) GCHandle.Alloc(icon);
#endif
#if DEBUG
			stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(text);
#else
			stack[3].s_class = (IntPtr) GCHandle.Alloc(text);
#endif
#if DEBUG
			stack[4].s_class = (IntPtr) DebugGCHandle.Alloc(strlist);
#else
			stack[4].s_class = (IntPtr) GCHandle.Alloc(strlist);
#endif
#if DEBUG
			stack[5].s_class = (IntPtr) DebugGCHandle.Alloc(ask);
#else
			stack[5].s_class = (IntPtr) GCHandle.Alloc(ask);
#endif
			stack[6].s_bool = checkboxReturn;
			stack[7].s_uint = options;
			staticInterceptor.Invoke("createKMessageBox##$?$$$", "createKMessageBox(KDialog*, const QIcon&, const QString&, const QStringList&, const QString&, bool*, KMessageBox::Options)", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
			((GCHandle) stack[2].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
			((GCHandle) stack[3].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[4].s_class);
#else
			((GCHandle) stack[4].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[5].s_class);
#else
			((GCHandle) stack[5].s_class).Free();
#endif
			checkboxReturn = stack[6].s_bool;
			return stack[0].s_int;
		}
	}
}
