class Q_EXPORT QImage
{
public:
    enum Endian {
	IgnoreEndian, 
	BigEndian,
	LittleEndian
    };

    QImage();
    QImage( int width, int height, int depth, int numColors=0,Endian bitOrder=IgnoreEndian );
    QImage( const QSize&, int depth, int numColors=0, Endian bitOrder=IgnoreEndian );
    QImage( const QString &fileName, const char* format=0 );
    QImage( const QByteArray &data );
    QImage( const QImage & );

    void	detach();
    QImage	copy()		const;
    QImage	copy(int x, int y, int w, int h, int conversion_flags=0) const;
    QImage	copy( const QRect& r ) const;

    bool	isNull()	const;

    int		width()		const prop(width);
    int		height()	const prop(height);
    QSize	size()		const prop(size);
    QRect	rect()		const prop(rect);
    int		depth()		const prop(depth);
    int		numColors()	const prop(numColors);
    Endian 	bitOrder()	const prop(bitOrder);

    uint	color( int i )	const;
    void	setColor( int i, uint c );
    void	setNumColors( int );

    bool	hasAlphaBuffer() const prop(alphaBuffer);
    void	setAlphaBuffer( bool );

    bool	allGray() const prop(allGray);
    bool        isGrayscale() const prop(grayscale);

    // uchar //     *bits()		const;
    // uchar //     *scanLine( int ) const;
    // uchar //    **jumpTable()	const;
    // QRgb  //     *colorTable()	const;
    int		numBytes()	const prop(numBytes);
    int		bytesPerLine()	const prop(bytesPerLine);

    bool	create( int width, int height, int depth, int numColors=0, Endian bitOrder=IgnoreEndian );
    bool	create( const QSize&, int depth, int numColors=0, Endian bitOrder=IgnoreEndian );
    void	reset();

    void	fill( uint pixel );
    void	invertPixels( bool invertAlpha = TRUE );

    QImage	convertDepth( int ) const;
    // QImage //	convertDepthWithPalette( int, QRgb* p, int pc, int cf=0 ) const;
    QImage	convertDepth( int, int conversion_flags ) const;
    QImage	convertBitOrder( Endian ) const;
    QImage	smoothScale(int width, int height) const;

    QImage	createAlphaMask( int conversion_flags=0 ) const;
    QImage	createHeuristicMask( bool clipTight=TRUE ) const;

    QImage	mirror() const;
    QImage	mirror(bool horizontally, bool vertically) const;
    QImage	swapRGB() const;

    static Endian systemBitOrder();
    static Endian systemByteOrder();

    static const char* imageFormat( const QString &fileName );
    static QStringList inputFormatList();
    static QStringList outputFormatList();

    bool	load( const QString &fileName, const char* format=0 );
    bool	loadFromData( QByteArray data, const char *format=0 );
    bool	save( const QString &fileName, const char* format ) const;

    bool	valid( int x, int y ) const;
    int		pixelIndex( int x, int y ) const;
    uint	pixel( int x, int y ) const;
    void	setPixel( int x, int y, uint index_or_rgb );

    // Auxiliary data
    int dotsPerMeterX() const;
    int dotsPerMeterY() const;
    void setDotsPerMeterX(int);
    void setDotsPerMeterY(int);
    QPoint offset() const;
    void setOffset(const QPoint&);
    QStringList textLanguages() const;
    QStringList textKeys() const;
    QString text(const char* key, const char* lang=0) const;
    void setText(const char* key, const char* lang, const QString&);
				 int sw, int sh, int conversion_flags );
};
