/***************************************************************************
                            kde_CSSStyleDeclaration.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_CSSSTYLEDECLARATION
#define KDE_CSSSTYLEDECLARATION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The <code> CSSStyleDeclaration </code> interface represents a
 single <a href="http://www.w3.org/TR/REC-CSS2/syndata.html#block">
 CSS declaration block </a> . This interface may be used to
 determine the style properties currently set in a block or to set
 style properties explicitly within the block.

  While an implementation may not recognize all CSS properties
 within a CSS declaration block, it is expected to provide access to
 all specified properties through the <code> CSSStyleDeclaration
 </code> interface. Furthermore, implementations that support a
 specific level of CSS should correctly handle <a
 href="http://www.w3.org/TR/REC-CSS2/about.html#shorthand"> CSS
 shorthand </a> properties for that level. For a further discussion
 of shorthand properties, see the <code> CSS2Properties </code>
 interface.

 
 @short *
 The <code> CSSStyleDeclaration </code> interface represents a
 single <a href="http://www.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_CSSStyleDeclaration * kde_new_CSSStyleDeclaration();
kde_CSSStyleDeclaration * kde_new_CSSStyleDeclaration1(kde_CSSStyleDeclaration* other);
void kde_del_CSSStyleDeclaration( kde_CSSStyleDeclaration* p );

/** *
 The parsable textual representation of the declaration block
 (including the surrounding curly braces). Setting this
 attribute will result in the parsing of the new value and
 resetting of the properties in the declaration block.

     
*/
kde_DOMString* kde_CSSStyleDeclaration_cssText(kde_CSSStyleDeclaration* instPointer);

/** *
 see @ref cssText

     
*/
void kde_CSSStyleDeclaration_setCssText(kde_CSSStyleDeclaration* instPointer,kde_DOMString* arg1);

/** *
 The number of properties that have been explicitly set in this
 declaration block.

     
*/
unsigned long kde_CSSStyleDeclaration_length(kde_CSSStyleDeclaration* instPointer);

/** *
 The CSS rule that contains this declaration block.

     
*/
kde_CSSRule* kde_CSSStyleDeclaration_parentRule(kde_CSSStyleDeclaration* instPointer);

/** *
 Used to retrieve the value of a CSS property if it has been
 explicitly set within this declaration block.

     
*/
kde_DOMString* kde_CSSStyleDeclaration_getPropertyValue(kde_CSSStyleDeclaration* instPointer,kde_DOMString* propertyName);

/** *
 Used to retrieve the object representation of the value of a
 CSS property if it has been explicitly set within this
 declaration block. This method returns null if the property is
 a <a href="http://www.w3.org/TR/REC-CSS2/about.html#shorthand">
 shorthand </a> property. Shorthand property values can only be
 accessed and modified as strings, using the <code>
 getPropertyValue </code> and <code> setProperty </code>
 methods.

     
*/
kde_CSSValue* kde_CSSStyleDeclaration_getPropertyCSSValue(kde_CSSStyleDeclaration* instPointer,kde_DOMString* propertyName);

/** *
 Used to remove a CSS property if it has been explicitly set
 within this declaration block.

     
*/
kde_DOMString* kde_CSSStyleDeclaration_removeProperty(kde_CSSStyleDeclaration* instPointer,kde_DOMString* propertyName);

/** *
 Used to retrieve the priority of a CSS property (e.g. the
 <code> "important" </code> qualifier) if the property has been
 explicitly set in this declaration block.

     
*/
kde_DOMString* kde_CSSStyleDeclaration_getPropertyPriority(kde_CSSStyleDeclaration* instPointer,kde_DOMString* propertyName);

/** *
 Used to set a property value and priority within this
 declaration block.

     
*/
void kde_CSSStyleDeclaration_setProperty(kde_CSSStyleDeclaration* instPointer,kde_DOMString* propertyName, kde_DOMString* value, kde_DOMString* priority);

/** *
 Used to retrieve the properties that have been explicitly set
 in this declaration block. The order of the properties
 retrieved using this method does not have to be the order in
 which they were set. This method can be used to iterate over
 all properties in this declaration block.

     
*/
kde_DOMString* kde_CSSStyleDeclaration_item(kde_CSSStyleDeclaration* instPointer,unsigned long index);

/** *

 not part of the DOM
     
*/
int kde_CSSStyleDeclaration_isNull(kde_CSSStyleDeclaration* instPointer);

#ifdef __cplusplus
}
#endif
#endif
