/***************************************************************************
                            kde_DOMString.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_DOMSTRING
#define KDE_DOMSTRING

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class implements the basic string we use in the DOM. We do not use
 QString for 2 reasons: Memory overhead, and the missing explicit sharing
 of strings we need for the DOM.

 All DOMStrings are explicitly shared (they behave like pointers), meaning
 that modifications to one instance will also modify all others. If you
 wish to get a DOMString that is independent, use @ref copy().
 
 @short *
 This class implements the basic string we use in the DOM.
*/

/** *
 default constructor. Gives an empty DOMString
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_DOMString * kde_new_DOMString();
kde_DOMString * kde_new_DOMString1(qt_QChar* str, unsigned int len);
kde_DOMString * kde_new_DOMString2(qt_QString * arg1);
kde_DOMString * kde_new_DOMString3(char* str);
void kde_del_DOMString( kde_DOMString* p );
kde_DOMString * kde_new_DOMString5(kde_DOMString* str);
void kde_DOMString_insert(kde_DOMString* instPointer,kde_DOMString* str, unsigned int pos);
int kde_DOMString_find(kde_DOMString* instPointer,qt_QChar* c, int start);
unsigned int kde_DOMString_length(kde_DOMString* instPointer);
void kde_DOMString_truncate(kde_DOMString* instPointer,unsigned int len);
void kde_DOMString_remove(kde_DOMString* instPointer,unsigned int pos, int len);

/** *
 Splits the string into two. The original string gets truncated to pos, and the rest is returned.
     
*/
kde_DOMString* kde_DOMString_split(kde_DOMString* instPointer,unsigned int pos);

/** *
 Returns a lowercase version of the string
     
*/
kde_DOMString* kde_DOMString_lower(kde_DOMString* instPointer);

/** *
 Returns an uppercase version of the string
     
*/
kde_DOMString* kde_DOMString_upper(kde_DOMString* instPointer);
qt_QChar* kde_DOMString_unicode(kde_DOMString* instPointer);
qt_QString * kde_DOMString_string(kde_DOMString* instPointer);
int kde_DOMString_toInt(kde_DOMString* instPointer);
int kde_DOMString_percentage(kde_DOMString* instPointer,int _percentage);
kde_DOMString* kde_DOMString_copy(kde_DOMString* instPointer);
int kde_DOMString_isNull(kde_DOMString* instPointer);
int kde_DOMString_isEmpty(kde_DOMString* instPointer);

/** *

 Use at own risk!!!
     
*/

#ifdef __cplusplus
}
#endif
#endif
