/***************************************************************************
                            kde_KAudioPlayer.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KAUDIOPLAYER
#define KDE_KAUDIOPLAYER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class provides one-shot-and-forget audio playing. You will never
 know if what you wanted to play really got played.

 It doesn't require linking any special libraries, as it operates over
 DCOP. In the current implementation, it only indirectly communicates
 with the aRts soundserver, using knotify as DCOP -> MCOP bridge.

 Due to that fact, if you need "fast" response times, more control or
 feedback, use the MCOP interfaces rather than this.

 An example of using this class is:

 <pre>
   KAudioPlayer::play("/var/share/foo.wav");
 </pre>

 If you want to use signals & slots, you can do something like:

 <pre>
   KAudioPlayer player("/var/share/foo.wav");
   connect(&button, SIGNAL(clicked()), &player, SLOT(play()));
 </pre>

 
 @short *
 This class provides one-shot-and-forget audio playing.
*/

/** *
 Constructor.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KAudioPlayer * kde_new_KAudioPlayer(qt_QString * filename, qt_QObject * parent, char* name);

/** *
 Destructor.
	 
*/
void kde_del_KAudioPlayer( kde_KAudioPlayer* p );

/** *
 Play function as slot.

 Plays the soundfile given to the constructor.
	 
*/
void kde_KAudioPlayer_play(kde_KAudioPlayer* instPointer);

/** *
 Static play function.

*/
void kde_KAudioPlayer_play1( qt_QString * filename);

#ifdef __cplusplus
}
#endif
#endif
