/***************************************************************************
                            kde_KCharSelect.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCHARSELECT
#define KDE_KCHARSELECT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A Widget which allows the user to select a character of a
 specified font in a table

 You can specify the font whoes characters should be displayed via
 @ref setFont(). Using @ref enableFontCombo() you can allow the
 user to choose the font from a combob-box. As only 256 characters
 are displayed at once in the table, using the spinbox on the top
 the user can choose starting from which chracater the table
 displayes them. This spinbox also can be enabled or disabled using
 @ref enableTableSpinBox().

 KCharSelect supports keyboard and mouse navigation. Click+Move
 selects always the character below the mouse cursor. Using the
 arrow keys the focus mark is moved around and with pressing RETURN
 or SPACE the cell which contains the focus mark gets selected.

 To get the current selected character, use the @ref chr()
 method. You can set the character which should be displayed with
 @ref setChar() and the table number which should be displayed with
 @ref setTableNum().

 @author Reginald Stadlbauer <reggie@kde.org>
 
 @version $Id: kde_KCharSelect.h,v 1.6 2002/12/30 14:37:05 geiseri Exp $

 @short Character-Selection Widget.
*/

/** *
 Constructor. @p font specifies which font should be displayed, @p
 chr which character should be selected and @p tableNum specifies
 the number of the table which should be displayed.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KCharSelect * kde_new_KCharSelect(qt_QWidget * parent, char* name, qt_QString * font, qt_QChar* chr, int tableNum);

/** *
 Reimplemented.
     
*/
qt_QSize * kde_KCharSelect_sizeHint(kde_KCharSelect* instPointer);

/** *
 Sets the font which is displayed to @p font
     
*/
void kde_KCharSelect_setFont(kde_KCharSelect* instPointer,qt_QString * font);

/** *
 Sets the currently selected character to @p chr.
     
*/
void kde_KCharSelect_setChar(kde_KCharSelect* instPointer,qt_QChar* chr);

/** *
 Sets the currently displayed table to @p tableNum.
     
*/
void kde_KCharSelect_setTableNum(kde_KCharSelect* instPointer,int tableNum);

/** *
 Returns the currently selected character.
     
*/
qt_QChar* kde_KCharSelect_chr(kde_KCharSelect* instPointer);

/** *
 Returns the currently displayed font.
     
*/
qt_QString * kde_KCharSelect_font(kde_KCharSelect* instPointer);

/** *
 Returns the currently displayed table
     
*/
int kde_KCharSelect_tableNum(kde_KCharSelect* instPointer);

/** *
 If @p e is set to TRUE, the combobox which allows the user to
 select the font which should be displayed is enabled, else
 disabled.
     
*/
void kde_KCharSelect_enableFontCombo(kde_KCharSelect* instPointer,int e);

/** *

 If @p e is set to TRUE, the spinbox which allows the user to
 specify which characters of the font should be displayed, is
 enabled, else disabled.
     
*/
void kde_KCharSelect_enableTableSpinBox(kde_KCharSelect* instPointer,int e);

/** *
 Returns wether the font combobox on the top is enabled or
 disabled.

*/
int kde_KCharSelect_isFontComboEnabled(kde_KCharSelect* instPointer);

/** *
 Returns wether the table spinbox on the top is enabled or
 disabled.

*/
int kde_KCharSelect_isTableSpinBoxEnabled(kde_KCharSelect* instPointer);
void kde_KCharSelect_fillFontCombo(kde_KCharSelect* instPointer);
void kde_KCharSelect_virtual_hook(kde_KCharSelect* instPointer,int identifier, void* data);
void kde_KCharSelect_fontSelected(kde_KCharSelect* instPointer,qt_QString * _font);
void kde_KCharSelect_tableChanged(kde_KCharSelect* instPointer,int _value);
void kde_KCharSelect_charHighlighted(kde_KCharSelect* instPointer,qt_QChar* c);
void kde_KCharSelect_charHighlighted1(kde_KCharSelect* instPointer);
void kde_KCharSelect_charActivated(kde_KCharSelect* instPointer,qt_QChar* c);
void kde_KCharSelect_charActivated1(kde_KCharSelect* instPointer);
void kde_KCharSelect_charFocusItemChanged(kde_KCharSelect* instPointer);
void kde_KCharSelect_charFocusItemChanged1(kde_KCharSelect* instPointer,qt_QChar* c);
void kde_KCharSelect_charTableUp(kde_KCharSelect* instPointer);
void kde_KCharSelect_charTableDown(kde_KCharSelect* instPointer);
void kde_KCharSelect_slotDoubleClicked(kde_KCharSelect* instPointer);

#ifdef __cplusplus
}
#endif
#endif
