/***************************************************************************
                            kde_KDCOPPropertyProxy.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDCOPPROPERTYPROXY
#define KDE_KDCOPPROPERTYPROXY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The KDCOPPropertyProxy class provides an easy way to publish Qt properties of a
 QObject through DCOP.

 The class provides DCOP equivalents for the Qt property methods setProperty() ,
 property() and propertyNames() and also provides automatic set/get methods for
 the properties of a QObject. That means for example if your object provides a
 QString property called foo , then KDCOPPropertyProxy translates DCOP calls
 "setFoo( QString )" and "QString foo()" automatically into the corresponding
 setProperty/property calls.
 
 @short *
 The KDCOPPropertyProxy class provides an easy way to publish Qt properties of a
 QObject through DCOP.
*/

/** *
 Convenience constructor. Use it if you want to use this class as object, in contrary
 to using the static methods of this class and providing a QObject argument for each
 call.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KDCOPPropertyProxy * kde_new_KDCOPPropertyProxy(qt_QObject * object);

/** *
 Destructor.
   
*/
void kde_del_KDCOPPropertyProxy( kde_KDCOPPropertyProxy* p );

/** *
 Convenience method, when using this class as object. See documentation of the constructor and
 static isPropertyRequest method.
   
*/
int kde_KDCOPPropertyProxy_isPropertyRequest(kde_KDCOPPropertyProxy* instPointer,qt_QCString* fun);

/** *
 Convenience method, when using this class as object. See documentation of the constructor and
 static processPropertyRequest method.
   
*/
int kde_KDCOPPropertyProxy_processPropertyRequest(kde_KDCOPPropertyProxy* instPointer,qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData);

/** *
 Returns true if the method request in the fun argument matches the signature of the three standard
 property methods or set/get methods for the properties of the object argument.

 Use this method in your own DCOPObject dispatcher to check if the DCOP request is a property
 request which can be handled by this class.
   
*/
int kde_KDCOPPropertyProxy_isPropertyRequest1( qt_QCString* fun, qt_QObject * object);

/** *
 Processes the given DCOP method request by translating the request into a setProperty/property call
 on the given QObject argument.
   
*/
int kde_KDCOPPropertyProxy_processPropertyRequest1( qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData, qt_QObject * object);

#ifdef __cplusplus
}
#endif
#endif
