/***************************************************************************
                            kde_KGlobalAccel.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KGLOBALACCEL
#define KDE_KGLOBALACCEL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 KGlobalAccel allows you to have global accelerators that are independent of
 the focused window. Unlike @ref KAccel it does not matter which window is 
 currently active.

 @short Configurable global shortcut support.
*/

/** *
 Creates a new KGlobalAccel object with the given @ref pParent and
 @ref psName.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KGlobalAccel * kde_new_KGlobalAccel(qt_QObject * pParent, char* psName);
void kde_del_KGlobalAccel( kde_KGlobalAccel* p );

/** *
 Checks whether the accelerators are enabled.

*/
int kde_KGlobalAccel_isEnabled(kde_KGlobalAccel* instPointer);

/** *
 Checks whether the accelerators are enabled.

*/
void kde_KGlobalAccel_setEnabled(kde_KGlobalAccel* instPointer,int bEnabled);

/** *
 Create an accelerator action.

 Usage:
<pre>
 insert( "Do Something", i18n("Do Something"),
   i18n("This action allows you to do something really great with this program to "
        "the currently open document."),
   ALT+CTRL+Key_Q, KKey::QtWIN+CTRL+Key_Q, this, SLOT(slotDoSomething()) );
</pre>

*/

/** *
 Removes the accelerator action identified by the name.
 Remember to also call updateConnections().

*/
int kde_KGlobalAccel_remove(kde_KGlobalAccel* instPointer,qt_QString * sAction);

/** *
 Use this to insert a label into the action list.  This will be
 displayed when the user configures shortcuts.

*/

/** *
 Updates the connections of the accelerations after changing them. 

*/
int kde_KGlobalAccel_updateConnections(kde_KGlobalAccel* instPointer);

/** *
 Set the shortcut to be associated with the action named by @p sAction.

*/
kde_KShortcut* kde_KGlobalAccel_shortcut(kde_KGlobalAccel* instPointer,qt_QString * sAction);

/** *
 Set the shortcut to be associated with the action named by @p sAction.

*/
int kde_KGlobalAccel_setShortcut(kde_KGlobalAccel* instPointer,qt_QString * sAction, kde_KShortcut* shortcut);

/** *
 Set the slot to be called when the shortcut of the action named
 by @p sAction is pressed.

*/
int kde_KGlobalAccel_setSlot(kde_KGlobalAccel* instPointer,qt_QString * sAction, qt_QObject * pObjSlot, char* psMethodSlot);

/** * 
 Enable or disable the action named by @p sAction.

*/
int kde_KGlobalAccel_setEnabled1(kde_KGlobalAccel* instPointer,qt_QString * sAction, int bEnabled);

/** *
 Returns the configuration group that is used to save the accelerators.

*/
qt_QString * kde_KGlobalAccel_configGroup(kde_KGlobalAccel* instPointer);

/** *
 Sets the configuration group that is used to save the accelerators.

*/
void kde_KGlobalAccel_setConfigGroup(kde_KGlobalAccel* instPointer,qt_QString * cg);

/** *
 Read all shortcuts from @p pConfig, or (if @p pConfig
 is zero) from the application's configuration file
 @ref KGlobal::config().

*/
int kde_KGlobalAccel_readSettings(kde_KGlobalAccel* instPointer,kde_KConfigBase* pConfig);

/** *
 Write the current shortcuts to @p pConfig,
 or (if @p pConfig is zero) to the application's
 configuration file.

*/
int kde_KGlobalAccel_writeSettings(kde_KGlobalAccel* instPointer,kde_KConfigBase* pConfig);

/** *
 Write the current shortcuts to @p pConfig,
 or (if @p pConfig is zero) to the application's
 configuration file.  Alternatively, if bGlobal is true, then write
 to kdeglobals.

*/
int kde_KGlobalAccel_writeSettings1(kde_KGlobalAccel* instPointer,kde_KConfigBase* pConfig, int bGlobal);

/** *

 KAccelActions::useFourModifierKeys().
	 
*/
int kde_KGlobalAccel_useFourModifierKeys( );
void kde_KGlobalAccel_virtual_hook(kde_KGlobalAccel* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
