/***************************************************************************
                            kde_KGradientSelector.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KGRADIENTSELECTOR
#define KDE_KGRADIENTSELECTOR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The KGradientSelector widget allows the user to choose
 from a one-dimensional range of colors which is given as a
 gradient between two colors provided by the programmer.
 
 @short *
 The KGradientSelector widget allows the user to choose
 from a one-dimensional range of colors which is given as a
 gradient between two colors provided by the programmer.
*/

/** *
 Constructs a horizontal color selector which
 contains a gradient between white and black.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KGradientSelector * kde_new_KGradientSelector(qt_QWidget * parent, char* name);

/** *
 Constructs a colors selector with orientation o which
 contains a gradient between white and black.
   
*/
kde_KGradientSelector * kde_new_KGradientSelector1(int o, qt_QWidget * parent, char* name);

/** *
 Destructs the widget.
   
*/
void kde_del_KGradientSelector( kde_KGradientSelector* p );

/** *
 Sets the two colors which span the gradient.
   
*/
void kde_KGradientSelector_setColors(kde_KGradientSelector* instPointer,qt_QColor * col1, qt_QColor * col2);
void kde_KGradientSelector_setText(kde_KGradientSelector* instPointer,qt_QString * t1, qt_QString * t2);

/** *
 Set each color on its own.
   
*/
void kde_KGradientSelector_setFirstColor(kde_KGradientSelector* instPointer,qt_QColor * col);
void kde_KGradientSelector_setSecondColor(kde_KGradientSelector* instPointer,qt_QColor * col);

/** *
 Set each description on its own
   
*/
void kde_KGradientSelector_setFirstText(kde_KGradientSelector* instPointer,qt_QString * t);
void kde_KGradientSelector_setSecondText(kde_KGradientSelector* instPointer,qt_QString * t);
qt_QColor * kde_KGradientSelector_firstColor(kde_KGradientSelector* instPointer);
qt_QColor * kde_KGradientSelector_secondColor(kde_KGradientSelector* instPointer);
qt_QString * kde_KGradientSelector_firstText(kde_KGradientSelector* instPointer);
qt_QString * kde_KGradientSelector_secondText(kde_KGradientSelector* instPointer);
void kde_KGradientSelector_virtual_hook(kde_KGradientSelector* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
