/***************************************************************************
                            kde_KHistoryCombo.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KHISTORYCOMBO
#define KDE_KHISTORYCOMBO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A combobox which implements a history like a unix shell. You can navigate
 through all the items by using the Up or Down arrows (configurable of
 course). Additionally, weighted completion is available. So you should
 load and save the completion list to preserve the weighting between
 sessions.

 KHistoryCombo obeys the HISTCONTROL environment variable to determine 
 whether duplicates in the history should be tolerated in 
 @ref addToHistory() or not. During construction of KHistoryCombo,
 duplicates will be disabled when HISTCONTROL is set to "ignoredups" or
 "ignoreboth". Otherwise, duplicates are enabled by default.

 @author Carsten Pfeiffer <pfeiffer@kde.org>

 @short A combobox for offering a history and completion.
*/

/** *
 Constructs a "read-write" combobox. A read-only history combobox
 doesn't make much sense, so it is only available as read-write.
 Completion will be used automatically for the items in the combo.

 The insertion-policy is set to NoInsertion, you have to add the items
 yourself via the slot @ref addToHistory. If you want every item added,
 use

 <pre>
 connect( combo, SIGNAL( activated( const QString& )),
          combo, SLOT( addToHistory( const QString& )));
 </pre>

 Use @ref QComboBox::setMaxCount() to limit the history.

 @p parent the parent object of this widget.
 @p name the name of this widget.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KHistoryCombo * kde_new_KHistoryCombo(qt_QWidget * parent, char* name);

/** *
 Same as the previous constructor, but additionally has the option
 to specify whether you want to let KHistoryCombo handle completion
 or not. If set to @p true, KHistoryCombo will sync the completion to the
 contents of the combobox.
     
*/
kde_KHistoryCombo * kde_new_KHistoryCombo1(int useCompletion, qt_QWidget * parent, char* name);

/** *
 Destructs the combo, the completion-object and the pixmap-provider
     
*/
void kde_del_KHistoryCombo( kde_KHistoryCombo* p );

/** *
 Inserts @p items into the combobox. @p items might get
 truncated if it is longer than @ref maxCount()

*/
void kde_KHistoryCombo_setHistoryItems(kde_KHistoryCombo* instPointer,qt_QStringList* items);

/** *
 Inserts @p items into the combobox. @p items might get
 truncated if it is longer than @ref maxCount()

 Set @p setCompletionList to true, if you don't have a list of
 completions. This tells KHistoryCombo to use all the items for the
 completion object as well.
 You won't have the benefit of weighted completion though, so normally
 you should do something like
 <pre>
 KConfig *config = kapp->config();
 QStringList list;

 list = config->readListEntry( "Completion list" );
 combo->completionObject()->setItems( list );
 list = config->readListEntry( "History list" );
 combo->setHistoryItems( list );

 [...]

 list = combo->completionObject()->items()
 config->writeEntry( "Completion list", list );
 list = combo->historyItems();
 config->writeEntry( "History list", list );
 </pre>

 Be sure to use different names for saving with KConfig if you have more
 than one KHistoryCombo.

 Note: When @p setCompletionList is true, the items are inserted into the
 KCompletion object with mode KCompletion::Insertion and the mode is set
 to KCompletion::Weighted afterwards.

*/
void kde_KHistoryCombo_setHistoryItems1(kde_KHistoryCombo* instPointer,qt_QStringList* items, int setCompletionList);

/** *
 Returns the list of history items. Empty, when this is not a read-write
 combobox.

*/
qt_QStringList* kde_KHistoryCombo_historyItems(kde_KHistoryCombo* instPointer);

/** *
 Removes all items named @p item.

*/
int kde_KHistoryCombo_removeFromHistory(kde_KHistoryCombo* instPointer,qt_QString * item);

/** *
 Sets a pixmap provider, so that items in the combobox can have a pixmap.
 @ref KPixmapProvider is just an abstract class with the one pure virtual
 method @ref KPixmapProvider::pixmapFor(). This method is called whenever
 an item is added to the KHistoryComboBox. Implement it to return your
 own custom pixmaps, or use the @ref KURLPixmapProvider from libkio,
 which uses @ref KMimeType::pixmapForURL to resolve icons.

 Set @p prov to 0L if you want to disable pixmaps. Default no pixmaps.

*/
void kde_KHistoryCombo_setPixmapProvider(kde_KHistoryCombo* instPointer,kde_KPixmapProvider* prov);

/** *

*/
kde_KPixmapProvider* kde_KHistoryCombo_pixmapProvider(kde_KHistoryCombo* instPointer);

/** *
 Resets the current position of the up/down history. Call this
 when you manually call @ref setCurrentItem() or @ref clearEdit().
     
*/
void kde_KHistoryCombo_reset(kde_KHistoryCombo* instPointer);

/** *
 Adds an item to the end of the history list and to the completion list.
 If @ref maxCount() is reached, the first item of the list will be
 removed.

 If the last inserted item is the same as @p item, it will not be
 inserted again.

 If @ref duplicatesEnabled() is false, any equal existing item will be
 removed before @p item is added.

 Note: By using this method and not the Q and KComboBox insertItem()
 methods, you make sure that the combobox stays in sync with the
 completion. It would be annoying if completion would give an item
 not in the combobox, and vice versa.

*/
void kde_KHistoryCombo_addToHistory(kde_KHistoryCombo* instPointer,qt_QString * item);

/** *
 Clears the history and the completion list.
     
*/
void kde_KHistoryCombo_clearHistory(kde_KHistoryCombo* instPointer);

/** *
 Handling key-events, the shortcuts to rotate the items.
     
*/

/** *
 Inserts @p items into the combo, honouring @ref pixmapProvider()
 Does not update the completionObject.

 Note: @ref duplicatesEnabled() is not honored here.

 Called from @ref setHistoryItems() and @ref setPixmapProvider()
     
*/
void kde_KHistoryCombo_insertItems(kde_KHistoryCombo* instPointer,qt_QStringList* items);

/** *

*/
int kde_KHistoryCombo_useCompletion(kde_KHistoryCombo* instPointer);

/** *
 Indicates that the user at least once rotated Up through the entire list
 Needed to allow going back after rotation.
     
*/
void kde_KHistoryCombo_virtual_hook(kde_KHistoryCombo* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
