//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QSocketNotifier;

/**

 The extended socket class.
 This class should be used instead of KSocket whenever the user needs
 fine-grained control over the socket being created. Unlike KSocket, which
 does everything at once, without much intervention, KExtendedSocket allows
 intervention at every step of the process and the setting of parameters.
 This class allows for the creation of both server and client sockets. The
 only difference is that the passiveSocket flag must be passed either to
 the constructor or to setSocketFlags(). If passiveSocket is used, the class will
 enable functions listen() and accept() and related signals, and will
 also disable readBlock() and writeBlock().
 To create a Unix socket, one would pass flag unixSocket to the constructor
 or setSocketFlags(). The hostname and service/port can be set to whatever is
 necessary. If no hostname is given, but a service/port is, the socket created
 will be implementation dependant (usually in /tmp). In any other case, the
 fields will be concatenated.
 To create an Internet socket, inetSocket flag can be used. If, on the other
 hand a specific IP protocol is desired, ipv4Socket and/or ipv6Socket can be
 used.
 Note that the socket type selection flags are cumulative. One could select
 Unix and Internet sockets by using unixSocket | inetSocket. Or, for instance,
 to make sure only IPv4 and IPv6 sockets are selected, even if future implementations
 support newer IP protocols, ipv4Socket | ipv6Socket is your guy.
 See {@link KExtendedSocketSignals} for signals emitted by KExtendedSocket
		@author Thiago Macieira <thiagom@mail.com>

		@version  kextsock.h,v 1.42 2003/10/07 22:09:16 mueller

		@short an extended socket.

*/
public class KExtendedSocket extends KBufferedIO  {
	protected KExtendedSocket(Class dummy){super((Class) null);}
	/**	
		 flags that can be passed down to the member functions
		   		@short    flags that can be passed down to the member functions
	*/
	public static final int anySocket = 0x00;
	public static final int knownSocket = 0x01;
	public static final int unixSocket = knownSocket|0x02;
	public static final int inetSocket = knownSocket|0x04;
	public static final int ipv4Socket = inetSocket|0x100;
	public static final int ipv6Socket = inetSocket|0x200;
	public static final int passiveSocket = 0x1000;
	public static final int canonName = 0x2000;
	public static final int noResolve = 0x4000;
	public static final int streamSocket = 0x8000;
	public static final int datagramSocket = 0x10000;
	public static final int rawSocket = 0x20000;
	public static final int inputBufferedSocket = 0x200000;
	public static final int outputBufferedSocket = 0x400000;
	public static final int bufferedSocket = 0x600000;

	/**	
		 status of the class
		 The status are sequential. If a change to one status is requested,
		 all the prior status will be passed and their actions, performed
		   		@short    status of the class  The status are sequential.
	*/
	public static final int error = -1;
	public static final int nothing = 0;
	public static final int lookupInProgress = 50;
	public static final int lookupDone = 70;
	public static final int created = 100;
	public static final int bound = 140;
	public static final int connecting = 200;
	public static final int connected = 220;
	public static final int listening = 200;
	public static final int accepting = 220;
	public static final int closing = 350;
	public static final int done = 400;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Creates an empty KExtendedSocket.
		   		@short    Creates an empty KExtendedSocket.
	*/
	public KExtendedSocket() {
		super((Class) null);
		newKExtendedSocket();
	}
	private native void newKExtendedSocket();
	/**	
		 Creates a socket with the given hostname and port.
			@param host the hostname
			@param port the port number
			@param flags flags
		   		@short    Creates a socket with the given hostname and port.
	*/
	public KExtendedSocket(String host, int port, int flags) {
		super((Class) null);
		newKExtendedSocket(host,port,flags);
	}
	private native void newKExtendedSocket(String host, int port, int flags);
	public KExtendedSocket(String host, int port) {
		super((Class) null);
		newKExtendedSocket(host,port);
	}
	private native void newKExtendedSocket(String host, int port);
	/**	
		 Creates a socket with the given hostname and service.
			@param host the hostname
			@param service the service
			@param flags flags
		   		@short    Creates a socket with the given hostname and service.
	*/
	public KExtendedSocket(String host, String service, int flags) {
		super((Class) null);
		newKExtendedSocket(host,service,flags);
	}
	private native void newKExtendedSocket(String host, String service, int flags);
	public KExtendedSocket(String host, String service) {
		super((Class) null);
		newKExtendedSocket(host,service);
	}
	private native void newKExtendedSocket(String host, String service);
	/**	
		 Resets the socket, disconnecting if still connected and
		 freeing any related resources still being kept.
				@short    Resets the socket, disconnecting if still connected and  freeing any related resources still being kept.
	*/
	public native void resetSocket();
	/**	
		 Returns the class status.
				@return the class status

		@short    Returns the class status.
		@see SockStatus
	*/
	public native int socketStatus();
	/**	
		 Returns the related system error code
		 Except for IO_LookupError errors, these are codes found in
		 errno
				@return the system error code
   
		@short    Returns the related system error code  Except for IO_LookupError errors, these are codes found in  errno
	*/
	public native int systemError();
	/**	
		 Sets the given flags.
			@param flags the flags to be set
				@return the new flags status, or -1 if flags can no longer be set
   
		@short    Sets the given flags.
	*/
	public native int setSocketFlags(int flags);
	/**	
		 Returns the current flags
				@return the current flags

		@short    Returns the current flags 
		@see Flags
	*/
	public native int socketFlags();
	/**	
		 Sets the hostname to the given value.
			@param host the hostname
				@return true on success, false on error
   
		@short    Sets the hostname to the given value.
	*/
	public native boolean setHost(String host);
	/**	
		 Returns the hostname.
				@return the hostname or null if no host has been set
   
		@short    Returns the hostname.
	*/
	public native String host();
	/**	
		 Sets the port/service.
			@param port the port
		   		@short    Sets the port/service.
	*/
	public native boolean setPort(int port);
	/**	
		 Sets the port/service.
			@param port the port
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Sets the port/service.
	*/
	public native boolean setPort(String port);
	/**	
		 Returns the port/service. If it is a port, the string contains a number.
				@return the port or null if it has not been set.
   
		@short    Returns the port/service.
	*/
	public native String port();
	/**	
		 Sets the address where we will connect to.
			@param host the hostname
			@param port port number
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Sets the address where we will connect to.
	*/
	public native boolean setAddress(String host, int port);
	/**	
		 Sets the address where we will connect to.
			@param host the hostname
			@param serv the service
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Sets the address where we will connect to.
	*/
	public native boolean setAddress(String host, String serv);
	/**	
		 Sets the hostname to which we will bind locally before connecting.
			@param host the hostname
				@return false if this is a passiveSocket, otherwise true.
   
		@short    Sets the hostname to which we will bind locally before connecting.
	*/
	public native boolean setBindHost(String host);
	/**	
		 Unsets the bind hostname. That is, don't request a binding host.
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Unsets the bind hostname.
	*/
	public native boolean unsetBindHost();
	/**	
		 Returns the hostname to which the socket will be/is bound.
				@return the host or null if it has not been set.
   
		@short    Returns the hostname to which the socket will be/is bound.
	*/
	public native String bindHost();
	/**	
		 Sets the port/service to which we will bind before connecting
			@param port the port number
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Sets the port/service to which we will bind before connecting
	*/
	public native boolean setBindPort(int port);
	/**	
		 Sets the port/service to which we will bind before connecting.
			@param service the port number or service name
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Sets the port/service to which we will bind before connecting.
	*/
	public native boolean setBindPort(String service);
	/**	
		 Unsets the bind port/service.
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Unsets the bind port/service.
	*/
	public native boolean unsetBindPort();
	/**	
		 Returns the service to which the socket will be/is bound.
				@return the host or null if it has not been set.
   
		@short    Returns the service to which the socket will be/is bound.
	*/
	public native String bindPort();
	/**	
		 Sets both host and port to which we will bind the socket. Will return
		 false if this is a passiveSocket.
			@param host the hostname
			@param port the port number
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Sets both host and port to which we will bind the socket.
	*/
	public native boolean setBindAddress(String host, int port);
	/**	
		 Sets both host and service to which we will bind the socket. Will return
		 false if this is a passiveSocket.
			@param host the hostname
			@param service the service
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Sets both host and service to which we will bind the socket.
	*/
	public native boolean setBindAddress(String host, String service);
	/**	
		 Unsets the bind address for the socket. That means that we won't
		 attempt to bind to an address before connecting.
				@return true if successful, false on error (e.g. connection already established)
   
		@short    Unsets the bind address for the socket.
	*/
	public native boolean unsetBindAddress();
	/**	
		 Sets the timeout value for the connection (if this is not passiveSocket) or
		 acception (if it is). In the event the given function
		 (connect or accept) returns due to time out, it's possible to call it again.
			 Setting the timeout to 0 disables the timeout feature.
			@param secs the timeout length, in seconds
			@param usecs the timeout complement, in microseconds
				@return false if setting timeout makes no sense in the context.
   
		@short    Sets the timeout value for the connection (if this is not passiveSocket) or  acception (if it is).
	*/
	public native boolean setTimeout(int secs, int usecs);
	public native boolean setTimeout(int secs);
	/**	
		 Returns the timeout value for the connection.
				@return the timeout value. 0 if there is no timeout.
   
		@short    Returns the timeout value for the connection.
	*/
	// timeval timeout(); >>>> NOT CONVERTED
	/**	
		 Sets/unsets blocking mode for the socket. When non-blocking mode is enabled,
		 I/O operations might return error and set errno to EWOULDBLOCK. Also,
		 it's not recommended to use this when using the class signals.
			@param enable if true, set blocking mode. False, non-blocking mode.
				@return false on error.
   
		@short    Sets/unsets blocking mode for the socket.
	*/
	public native boolean setBlockingMode(boolean enable);
	/**	
		 Returns the current blocking mode for this socket.
				@return true if in blocking mode
   
		@short    Returns the current blocking mode for this socket.
	*/
	public native boolean blockingMode();
	/**	
		 Sets/unsets address reusing flag for this socket.
			 This function returns true if the value was set correctly. That is NOT
		 the result of the set.
			@param enable if true, set address reusable
				@return true on success, false on failure. If the socket was not yet created,
 the value is only remembered. In this case the return value is always true.
   
		@short    Sets/unsets address reusing flag for this socket.
	*/
	public native boolean setAddressReusable(boolean enable);
	/**	
		 Returns whether this socket's address can be reused
				@return true if the address can be reused
   
		@short    Returns whether this socket's address can be reused
	*/
	public native boolean addressReusable();
	/**	
		 Sets/unsets the v6-only flag for IPv6 sockets.
			 When an IPv6 socket is in use, communication with IPv4 sockets is
		 guaranteed by translating those IPv4 addresses into IPv6 ones
		 (specifically, the v4-mapped addresses). This flag allows that
		 behavior to be turned on and off.
			 Note that this does not have any effect on sockets that are not
		 IPv6 and the function will always return false in those cases.
		 Also note that this flag defaults to off in order to accommodate
		 existing applications.
			@param enable if true, no IPv4 translation will be performed;
					this socket will be restricted to IPv6 communication
				@return true on success, false on failure.

		@short    Sets/unsets the v6-only flag for IPv6 sockets.
		@see #localAddress
		@see #to
		@see #find
		@see #out
		@see #if
		@see #this
		@see #is
		@see #an
		@see IPv6
		@see #socket
	*/
	public native boolean setIPv6Only(boolean enable);
	/**	
		 Returns the status of the v6-only flag for IPv6 sockets.
				@return true if the flag is set to on; false if it is not. If this
 socket is not an IPv6 one, the return value is false.

		@short    Returns the status of the v6-only flag for IPv6 sockets.
		@see #setIPv6Only
	*/
	public native boolean isIPv6Only();
	/**	
		 Sets the buffer sizes for this socket.
			 This implementation allows any size for both parameters. The value given
		 will be interpreted as the maximum size allowed for the buffers, after
		 which the I/O functions will stop buffering. The value of -1 will be
		 interpreted as "unlimited" size. The value of -2 means "no change".
			 Note: changing the buffer size to 0 for any buffer will cause the given
		 buffer's to be discarded. Likewise, setting the size to a value less than
		 the current size will cause the buffer to be shrunk to the wanted value,
		 as if the data had been read.
			@param rsize read buffer size
			@param wsize write buffer size
				@return true on success, false if this is not possible in this state (e.g. connection
         not established yet)
   
		@short    Sets the buffer sizes for this socket.
	*/
	public native boolean setBufferSize(int rsize, int wsize);
	public native boolean setBufferSize(int rsize);
	/**	
		 Returns the local socket address
				@return the local socket address, can be 0 if the connection has not been established
         yet
   
		@short    Returns the local socket address
	*/
	// const KSocketAddress* localAddress(); >>>> NOT CONVERTED
	/**	
		 Returns the peer socket address. Use KExtendedSocket.resolve() to
		 resolve this to a human-readable hostname/service or port.
				@return the peer address, can be 0 if the connection has not been established yet
         or the socket is passive
   
		@short    Returns the peer socket address.
	*/
	// const KSocketAddress* peerAddress(); >>>> NOT CONVERTED
	/**	
		 Returns the file descriptor
				@return the file descriptor. -1 if there is no fd yet.
   
		@short    Returns the file descriptor
	*/
	public native int fd();
	/**	
		 Performs lookup on the addresses we were given before.
			 This will perform lookups on the bind addresses if they were given.
				@return 0 or an error. Do not rely on the values returned by lookup
 as of now. They are not specified.
   
		@short    Performs lookup on the addresses we were given before.
	*/
	public native int lookup();
	/**	
		 Starts an asynchronous lookup for the addresses given.
			 When the lookup is done, the lookupReady signal will be emitted.
			 Note that, depending on the parameters for the lookup, this function might
		 know the results without the need for blocking or queuing an
		 asynchronous lookup. That means that the lookupReady signal might be
		 emitted by this function, so your code should be prepared for that.
			 One such case is when noResolve flag is set.
		 If this function is able to determine the results without queuing
		 and the lookup failed, this function will return -1.
				@return 0 on success or -1 on error. Note that
 returning 0 means that either we are in the process of doing
 lookup or that it has finished already.
   
		@short    Starts an asynchronous lookup for the addresses given.
	*/
	public native int startAsyncLookup();
	/**	
		 Cancels any on-going asynchronous lookups
		   		@short    Cancels any on-going asynchronous lookups
	*/
	public native void cancelAsyncLookup();
	/**	
		 Place the socket in listen mode. The parameters are the same as for
		 the system listen() call.
			@param N the queue length for pending connections
				@return 0 on success, -1 on system error (errno
         available) and -2 if this is not a passiveSocket.
   
		@short    Place the socket in listen mode.
	*/
	public native int listen(int N);
	public native int listen();
	/**	
		 Accepts an incoming connection from the socket. If this socket is in
		 blocking mode, this function will block until a connection is received.
		 Otherwise, it might return with error. The sock parameter will be
		 initialised with the newly created socket.
			 Upon successful acception (i.e., this function returns 0), the newly
		 created socket will be already connected. The socket will be unbuffered
		 and readyRead() and readyWrite() signals will be disabled.
			@param sock a pointer to an KExtendedSocket variable
				@return 0 on success, -1 on system error (errno set) and -2 if this is
 not a passiveSocket and -3 if this took too long (time out)
   
		@short    Accepts an incoming connection from the socket.
	*/
	// int accept(KExtendedSocket*& arg1); >>>> NOT CONVERTED
	/**	
		 Attempts to connect to the remote host.
		 After successful connection (return value 0), the socket will be ready
		 for I/O operations. Note, however, that not all signals may be enabled
		 for emission by this socket:
		
			<li>
			readyRead and readyWrite signals will be enabled only if
			 enableRead or enableWrite were called. You can still enable
			    them by calling those functions, of course.
			</li>
			
			<li>
			#closed() will only be sent if we are indeed reading from the input
			    stream. That is, if this socket is buffering the input. See setBufferSize
			</li>
				 Note that, in general, functions inherited/overridden from KBufferedIO will only
		 work on buffered sockets, like bytesAvailable and bytesToWrite.
		
			<li>
			0: success
			</li>
			
			<li>
			-1: system error, errno was set accordingly
			</li>
			
			<li>
			-2: this socket cannot connect(); this is a passiveSocket. It can also
			   mean that the function was unable to make a connection with the given
			   bind address or that an asynchronous connection attempt is already
			   in progress.
			</li>
			
			<li>
			-3: connection timed out
			</li>
				   		@return The return values are:

		@short    Attempts to connect to the remote host.
	*/
	public native int connect();
	/**	
		 Starts an asynchronous connect. This works exactly the same as #connect,
		 except that the connection result won't be returned.
			 Note that those signals might be emitted before this function returns, so your
		 code should be prepared for that condition.
			 You must call cancelAsyncConnect() before you delete the socket if you
		 call this.  Otherwise you will have crashes.
				@return 0 on successful queuing of the connect or -1 on error.
         If this function returns 0, then the connectionSuccess() or the
 connectionFailed() signals will be emitted.
   
		@short    Starts an asynchronous connect.
	*/
	public native int startAsyncConnect();
	/**	
		 Cancels any on-going asynchronous connection attempt.
		   		@short    Cancels any on-going asynchronous connection attempt.
	*/
	public native void cancelAsyncConnect();
	/**	
		 Implementation of QIODevice.open() pure function.
		 This depends on the target host address already being there.
		 If this is a passiveSocket, this is identical to call listen(); else, if
		 this is not a passiveSocket and no connection attempt is in progress, this
		 is like connect(). If one is in progress, this function will fail.
			@param mode the open mode. Must be IO_Raw | IO_ReadWrite
				@return true if successful, false when an error occurred or the most was
         not correct
   
		@short    Implementation of QIODevice.open() pure virtual function.
	*/
	public native boolean open(int mode);
	public native boolean open();
	/**	
		 Closes the socket. If we have data still in the write buffer yet to be
		 sent, the socket won't be closed right now. It'll be closed after we managed
		 to send everything out.
		 If you want to close the socket now, you may want to call flush() first,
		 and then closeNow().
		   		@short    Closes the socket.
	*/
	public native void close();
	/**	
		 Closes the socket now, discarding the contents of the write buffer, if any.
		 The read buffer's contents are kept until they are emptied by read operations
		 or the class is destroyed.
		   		@short    Closes the socket now, discarding the contents of the write buffer, if any.
	*/
	public native void closeNow();
	/**	
		 Releases the socket and anything we have holding on it. The class cannot
		 be used anymore. In other words, this is just like closeNow(), but it does
		 not actually close the socket.
			 This is useful if you just want to connect and don't need the rest of the
		 class.
			 Note that the buffers' contents will be discarded.
			 Use of this method is discouraged, because the socket created might be such that
		 normal library routines can't handle (read, write, close, etc.)
		   		@short    Releases the socket and anything we have holding on it.
	*/
	public native void release();
	/**	
		 Flushes the socket buffer. You need not call this method during normal
		 operation as we will try and send everything as soon as possible.
		 However, if you want to make sure that data in the buffer is being sent
		 at this moment, you can call this function. It will try to send as much
		 data as possible, but it will stop as soon as the kernel cannot receive
		 any more data, and would possibly block.
			 By repeatedly calling this function, the behavior will be like that of
		 a blocking socket. Indeed, if this function is called with the kernel not
		 ready to receive data, it will block, unless this is a non-blocking socket.
			 This function does not touch the read buffer. You can empty it by calling
		 readBlock() with a null destination buffer.
		   		@short    Flushes the socket buffer.
	*/
	public native void flush();
	/**	
		 Returns length of this socket. This call is not supported on sockets.
				@return the length of this socket, or 0 if unsupported
   
		@short    Returns length of this socket.
	*/
	public native long size();
	/**	
		 Returns relative position from start. This call is not supported on sockets.
				@return the relative position from the start, or 0 if unsupported
   
		@short    Returns relative position from start.
	*/
	public native long at();
	/**	
		 Returns true if we are at position. This is not supported on sockets.
			@param i the position to check
				@return true if we art at the given position, or always true if unsupported.
   
		@short    Returns true if we are at position.
	*/
	public native boolean at(int i);
	/**	
		 Returns true if we are at the end. This is not supported on sockets, but
		 we always are at the end in a socket...
				@return true if we are at the end. Always false if unsupported.
   
		@short    Returns true if we are at the end.
	*/
	public native boolean atEnd();
	/**	
		 Reads a block of data from the socket.
			 If the socket is not buffered, this function will simply call the underlying
		 read method. This function will block if the socket is not on non-blocking mode
		 (see setBlockingMode) and there is not enough data to be read in the
		 Operating System yet. If we are in non-blocking operation, the call will
		 fail in this case.
			 However, if we are buffering, this function will instead read from the
		 buffer while there is available data. This function will never block
		 in buffering mode, which means that if you try to read while the buffers
		 are empty, this function will always return -1 and set the system error to
		 EWOULDBLOCK (aka EAGAIN), so as to mimic non-blocking operation.
			@param data where we will write the read data to
			@param maxlen maximum length of data to be read
		
			<li>
			return an error, with EWOULDBLOCK system error, if we buffering
			   or we are in non-blocking mode
			</li>
			
			<li>
			otherwise, it'll block
			 This function returns 0, if the function detected end-of-file condition
			 (socket was closed)
			   
			</li>		@return the number of bytes effectively read, or a negative number in case
 or an error. If the <code>data</code> param is not null, then this is also the number
 of bytes copied into that buffer. If the return value is different than
 <code>maxlen</code>, then this function encountered a situation in which no more
 bytes were available. Subsequent calls might cause this function to one
 of these behaviours:

		@short    Reads a block of data from the socket.
	*/
	public native long readBlock(StringBuffer data, long maxlen);
	/**	
		 Writes a block of data to the socket.
			 If the socket is not buffered, this function will simply call the underlying
		 write method. This means that the function might block if that method blocks
		 as well. That situation is possible if we are not in non-blocking mode and
		 the operating system buffers are full for this socket. If we are in
		 non-blocking mode and the operating system buffers are full, this function
		 will return -1 and the system error will be set to EWOULDBLOCK.
			 If we are buffering, this function will simply transfer the data into the
		 write buffer. This function will then always succeed, as long as there is
		 enough room in the buffer. If the buffer size was limited and that limit
		 is reached, this function will copy no more bytes than that limit. Trying
		 to write with a full buffer will return -1 and set system error to
		 EWOULDBLOCK.
			@param data the data to write
			@param len the length of data to write
				@return the number of bytes written from <code>data</code> buffer.
 The return value might be less than <code>len</code> if the output buffers cannot
 accommodate that many bytes and -1 in the case of an errro.
   
		@short    Writes a block of data to the socket.
	*/
	public native long writeBlock(String data, long len);
	/**	
		 Peeks at a block of data from the socket.
			 This is exactly like read, except that the data won't be flushed from the
		 read buffer.
			 If this socket is not buffered, this function will always return with
		 0 bytes copied.
			@param data where to store the data
			@param maxlen how many bytes to copy, at most
				@return the number of bytes copied. 0 does not mean end-of-file
         condition.
   
		@short    Peeks at a block of data from the socket.
	*/
	public native int peekBlock(String data, int maxlen);
	/**	
		 Reimplementation of unreadBlock() method. This is so because unreading in
		 sockets doesn't make sense, so this function will always return -1 (error)
		 and set the system error to ENOSYS.
				@return always -1 (error)
   
		@short    Reimplementation of unreadBlock() method.
	*/
	public native int unreadBlock(String data, int len);
	/**	
		 Returns the number of available bytes yet to be read via readBlock
		 and family of functions.
			 Note: as of now, this only works on input-buffered sockets. This will
		 change in the future
				@return The number of available bytes, or -1 on error or -2 if this call is invalid
 in the current state.
   
		@short    Returns the number of available bytes yet to be read via readBlock  and family of functions.
	*/
	public native int bytesAvailable();
	/**	
		 Waits <code>msec</code> milliseconds for more data to be available (use 0 to
		 wait forever). The return value is the amount of data available for
		 read in the read buffer.
			@param msec milliseconds to wait
				@return -1 in case of system error and -2 in case of invalid socket
         state
   
		@short    Waits <code>msec</code> milliseconds for more data to be available (use 0 to  wait forever).
	*/
	public native int waitForMore(int msec);
	/**	
		 Gets a single character (unsigned char) from the stream.
				@return the value of the character. Negative if there was an error.
   
		@short    Gets a single character (unsigned char) from the stream.
	*/
	public native int getch();
	/**	
		 Writes a single character (unsigned char) to the stream. All other bits
		 will be ignored.
			@param ch character to write, converted to char
		   		@short    Writes a single character (unsigned char) to the stream.
	*/
	public native int putch(int ch);
	/**	
		 Unreads one character from the stream. This is not possible on sockets.
				@return always returns -1 on sockets.
   
		@short    Unreads one character from the stream.
	*/
	public native int ungetch(int arg1);
	/**	
		 Toggles the emission of the readyRead signal.
			 Note that this signal is emitted every time more data is available to be
		 read, so you might get flooded with it being emitted every time, when in
		 non-buffered mode. However, in buffered mode, this signal will be
		 emitted only when there is data coming in from the wire.
		 By default, this flag is set to false, i.e., signal not being emitted.
			@param enable if true, the signal will be emitted
		   		@short    Toggles the emission of the readyRead signal.
	*/
	public native void enableRead(boolean enable);
	/**	
		 Toggles the emission of the readyWrite signal.
			 Note that this signal is emitted only when the OS is ready to receive more
		 data, which means that the write buffer is empty. And when that is reached,
		 this signal will possibly be emitted on every loop, so you might
		 want to disable it. By default, this flag is set to false.
			@param enable if true, the signal will be emitted
		   		@short    Toggles the emission of the readyWrite signal.
	*/
	public native void enableWrite(boolean enable);
	/**	
		 Performs resolution on the given socket address.
			 That is, tries to resolve the raw form of the socket address into a textual
		 representation.
			@param sock the socket address
			@param len the length of the socket address
			@param host where the hostname will be written
			@param port where the service-port will be written
			@param flags the same flags as getnameinfo()
				@return 0 on success, nonzero otherwise.
   
		@short    Performs resolution on the given socket address.
	*/
	// int resolve(sockaddr* arg1,ksocklen_t arg2,QString& arg3,QString& arg4,int arg5); >>>> NOT CONVERTED
	// int resolve(sockaddr* arg1,ksocklen_t arg2,QString& arg3,QString& arg4); >>>> NOT CONVERTED
	/**	
		 Performs resolution on the given socket address.
			 That is, tries to resolve the raw form of the socket address into a textual
		 representation.
			@param sock the socket address
			@param host where the hostname will be written
			@param port where the service-port will be written
			@param flags the same flags as getnameinfo()
				@return 0 on success, nonzero otherwise.
   
		@short    Performs resolution on the given socket address.
	*/
	// int resolve(KSocketAddress* arg1,QString& arg2,QString& arg3,int arg4); >>>> NOT CONVERTED
	// int resolve(KSocketAddress* arg1,QString& arg2,QString& arg3); >>>> NOT CONVERTED
	/**	
		 Performs lookup on the given hostname/port combination and returns a list
		 of matching addresses.
		 The error code can be transformed into string by KExtendedSocket.strError()
		 with code of IO_LookupError.
			 IMPORTANT: the result values of the QPtrList must be deleted after use. So,
		 if you don't copy the KAddressInfo objects, the best way to assure that
		 is to call setAutoDelete(true) on the list right after this function
		 returns. If you do copy the results out, you must assure that the objects
		 get deleted when they are not needed any more.
			@param host the hostname to look up
			@param port the port/service to look up
			@param flags flags to be used when looking up, Flags
			@param error pointer to a variable holding the error code
				@return a list of KAddressInfos
   
		@short    Performs lookup on the given hostname/port combination and returns a list  of matching addresses.
	*/
	// QPtrList<KAddressInfo> lookup(const QString& arg1,const QString& arg2,int arg3,int* arg4); >>>> NOT CONVERTED
	// QPtrList<KAddressInfo> lookup(const QString& arg1,const QString& arg2,int arg3); >>>> NOT CONVERTED
	// QPtrList<KAddressInfo> lookup(const QString& arg1,const QString& arg2); >>>> NOT CONVERTED
	/**	
		 Returns the local socket address
		 Remember to delete the returned object when it is no longer needed.
			@param fd the file descriptor
				@return the local socket address or 0 if an error occurred. Delete after use.
   
		@short    Returns the local socket address  Remember to delete the returned object when it is no longer needed.
	*/
	// KSocketAddress* localAddress(int arg1); >>>> NOT CONVERTED
	/**	
		 Returns the peer socket address. Use KExtendedSocket.resolve() to
		 resolve this to a human-readable hostname/service or port.
		 Remember to delete the returned object when it is no longer needed.
			@param fd the file descriptor
				@return the peer socket address or 0 if an error occurred. Delete after use.
   
		@short    Returns the peer socket address.
	*/
	// KSocketAddress* peerAddress(int arg1); >>>> NOT CONVERTED
	/**	
		 Returns the representing text of this error code
			@param code the error code, as seen in status()
			@param syserr the system error, as from systemError()
				@return the text for the given error code
   
		@short    Returns the representing text of this error code
	*/
	public static native String strError(int code, int syserr);
	/**	
		 Sets/unsets address reusing flag for this socket.
			 This function returns true if the value was set correctly. That is NOT
		 the result of the set.
			@param fd the file descriptor
			@param enable if true, set address reusable
				@return true on success, false on failure.
   
		@short    Sets/unsets address reusing flag for this socket.
	*/
	public static native boolean setAddressReusable(int fd, boolean enable);
	protected native QSocketNotifier readNotifier();
	protected native QSocketNotifier writeNotifier();
	/**	
		 Sets the error code
		   		@short    Sets the error code
	*/
	protected native void setError(int errorkind, int error);
	protected native void cleanError();
	/**	
		 Sets the socket status. For derived classes only.
		   		@short    Sets the socket status.
	*/
	protected native void setSocketStatus(int status);
	protected native void socketActivityRead();
	protected native void socketActivityWrite();
	protected native void dnsResultsReady();
	protected native void startAsyncConnectSlot();
	protected native void connectionEvent();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
