//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;

/**

 Provides information about I/O (Internet, etc.) settings chosen/set
 by the end user.
 KProtocolManager has a heap of static functions that allows only read
 access to KDE's IO related settings. These include proxy, cache, file
 transfer resumption, timeout and user-agent related settings.
 The information provided by this class is generic enough to be applicable
 to any application that makes use of KDE's IO sub-system.  Note that this
 mean the proxy, timeout etc. settings are saved in a separate user-specific
 config file and not in the config file of the application.
 Original author:
 Revised by:
		@author Dawit Alemayehu <adawit@kde.org>

		@short    Provides information about I/O (Internet, etc.
		@see KPAC

*/
public class KProtocolManager implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KProtocolManager(Class dummy){}

	/**	
		 Types of proxy configuration
		
			<li>
			NoProxy     - No proxy is used
			</li>
			
			<li>
			ManualProxy - Proxies are manually configured
			</li>
			
			<li>
			PACProxy    - A Proxy configuration URL has been given
			</li>
			
			<li>
			WPADProxy   - A proxy should be automatically discovered
			</li>
			
			<li>
			EnvVarProxy - Use the proxy values set through environment variables.
			   
			</li>		@short    Types of proxy configuration
	*/
	public static final int NoProxy = 0;
	public static final int ManualProxy = 1;
	public static final int PACProxy = 2;
	public static final int WPADProxy = 3;
	public static final int EnvVarProxy = 4;

	/**	
		 Proxy authorization modes.
		
			<li>
			Prompt     - Ask for authorization as needed
			</li>
			
			<li>
			Automatic  - Use auto login as defined in kionetrc files.
			   
			</li>		@short    Proxy authorization modes.
	*/
	public static final int Prompt = 0;
	public static final int Automatic = 1;

	public KProtocolManager() {
		newKProtocolManager();
	}
	private native void newKProtocolManager();
	public KProtocolManager(KProtocolManager arg1) {
		newKProtocolManager(arg1);
	}
	private native void newKProtocolManager(KProtocolManager arg1);
	/**	
		 Returns the default user-agent string.
				@return the default user-agent string
   
		@short    Returns the default user-agent string.
	*/
	public static native String defaultUserAgent();
	/**	
		 Returns the default user-agent value.
			@param keys can be any of the following:
		
			<li>
			'o'	Show OS
			</li>
			
			<li>
			'v'	Show OS Version
			</li>
			
			<li>
			'p'	Show platform
			</li>
			
			<li>
			'm'	Show machine architecture
			</li>
			
			<li>
			'l'	Show language
			</li>
					@return the default user-agent value with the given <code>keys</code>
   
		@short    Returns the default user-agent value.
	*/
	public static native String defaultUserAgent(String keys);
	/**	
		 Returns the userAgent string configured for the
		 specified host.
			 If hostname is not found or is empty (i.e. "" or
		 null) this function will return the default
		 user agent.
			@param hostname name of the host
				@return specified userAgent string
   
		@short    Returns the userAgent string configured for the  specified host.
	*/
	public static native String userAgentForHost(String hostname);
	/**	
		 Returns the preferred timeout value for reading from
		 remote connections in seconds.
				@return timeout value for remote connection in secs.
   
		@short    Returns the preferred timeout value for reading from  remote connections in seconds.
	*/
	public static native int readTimeout();
	/**	
		 Returns the preferred timeout value for remote connections
		 in seconds.
				@return timeout value for remote connection in secs.
   
		@short    Returns the preferred timeout value for remote connections  in seconds.
	*/
	public static native int connectTimeout();
	/**	
		 Returns the preferred timeout value for proxy connections
		 in seconds.
				@return timeout value for proxy connection in secs.
   
		@short    Returns the preferred timeout value for proxy connections  in seconds.
	*/
	public static native int proxyConnectTimeout();
	/**	
		 Returns the preferred response timeout value for
		 remote connecting in seconds.
				@return timeout value for remote connection in seconds.
   
		@short    Returns the preferred response timeout value for  remote connecting in seconds.
	*/
	public static native int responseTimeout();
	/**	
		 Returns whether or not the user specified the
		 use of proxy server to make connections.
				@return true to use a proxy
   
		@short    Returns whether or not the user specified the  use of proxy server to make connections.
	*/
	public static native boolean useProxy();
	/**	
		 Returns whether or not the the proxy server
		 lookup should be reversed or not.
				@return true to use a reversed proxy
   
		@short    Returns whether or not the the proxy server  lookup should be reversed or not.
	*/
	public static native boolean useReverseProxy();
	/**	
		 Returns the type of proxy configuration that is used.
				@return the proxy type
   
		@short    Returns the type of proxy configuration that is used.
	*/
	public static native int proxyType();
	/**	
		 Returns the way proxy authorization should be handled.
				@return the proxy authorization mode

		@short    Returns the way proxy authorization should be handled.
		@see ProxyAuthMode
	*/
	public static native int proxyAuthMode();
	/**	
		 Returns the strings for hosts that should contacted
		 DIRECTLY, bypassing any proxy settings.
				@return a list of (comma-separated) hostnames or partial host
         names
   
		@short    Returns the strings for hosts that should contacted  DIRECTLY, bypassing any proxy settings.
	*/
	public static native String noProxyFor();
	public static native String proxyFor(String protocol);
	/**	
		 Returns the Proxy server address for a given URL
		 If automatic proxy configuration is configured, KPAC
		 is used to determine the proxy server, otherwise the return
		 value of proxyFor for the URL's protocol is used.
		 If an empty string is returned, the request is to be aborted,
		 a return value of "DIRECT" requests a direct connection.
			@param url the URL whose proxy info is needed
				@return the proxy server address if one is available
          or null otherwise
   
		@short    Returns the Proxy server address for a given URL  If automatic proxy configuration is configured, KPAC  is used to determine the proxy server, otherwise the return  value of proxyFor for the URL's protocol is used.
	*/
	public static native String proxyForURL(KURL url);
	/**	
		 Marks this proxy as bad (down). It will not be used for the
		 next 30 minutes. (The script may supply an alternate proxy)
			@param proxy the proxy to mark as bad (as URL)
		   		@short    Marks this proxy as bad (down).
	*/
	public static native void badProxy(String proxy);
	/**	
		 Returns the URL of the script for automatic proxy configuration.
				@return the proxy configuration script
   
		@short    Returns the URL of the script for automatic proxy configuration.
	*/
	public static native String proxyConfigScript();
	/**	
		 Returns true/false to indicate whether a cache
		 should be used
				@return true to use the cache, false otherwisea
   
		@short    Returns true/false to indicate whether a cache  should be used
	*/
	public static native boolean useCache();
	/**	
		 Returns the maximum age in seconds cached files should be
		 kept before they are deleted as necessary.
				@return the maximum cache age in seconds
   
		@short    Returns the maximum age in seconds cached files should be  kept before they are deleted as necessary.
	*/
	public static native int maxCacheAge();
	/**	
		 Returns the maximum size that can be used for caching.
			 By default this function returns the DEFAULT_MAX_CACHE_SIZE
		 value as defined in http_slave_defaults.h.  Not that the
		 value returned is in bytes, hence a value of 5120 would mean
		 5 Kb.
				@return the maximum cache size in bytes
   
		@short    Returns the maximum size that can be used for caching.
	*/
	public static native int maxCacheSize();
	/**	
		 The directory which contains the cache files.
				@return the directory that contains the cache files
   
		@short    The directory which contains the cache files.
	*/
	public static native String cacheDir();
	/**	
		 Returns the Cache control directive to be used.
				@return the cache control value
   
		@short    Returns the Cache control directive to be used.
	*/
	public static native int cacheControl();
	/**	
		 Returns true if partial downloads should be
		 automatically resumed.
				@return true to resume partial downloads
   
		@short    Returns true if partial downloads should be  automatically resumed.
	*/
	public static native boolean autoResume();
	/**	
		 Returns true if partial downloads should be marked
		 with a ".part" extension.
				@return true if partial downloads should get an ".part" extension
   
		@short    Returns true if partial downloads should be marked  with a ".
	*/
	public static native boolean markPartial();
	/**	
		 Returns the minimum file size for keeping aborted
		 downloads.
			 Any data downloaded that does not meet this minimum
		 requirement will simply be discarded. The default size
		 is 5 KB.
				@return the minimum keep size for aborted downloads in bytes
   
		@short    Returns the minimum file size for keeping aborted  downloads.
	*/
	public static native int minimumKeepSize();
	/**	
		 Returns true if proxy connections should be persistent.
				@return true if proxy connections should be persistent

		@short    Returns true if proxy connections should be persistent.
	*/
	public static native boolean persistentProxyConnection();
	/**	
		 Returns true if connections should be persistent
				@return true if the connections should be persistent
   
		@short    Returns true if connections should be persistent
	*/
	public static native boolean persistentConnections();
	/**	
		 Force a reload of the general config file of
		 io-slaves ( kioslaverc).
		   		@short    Force a reload of the general config file of  io-slaves ( kioslaverc).
	*/
	public static native void reparseConfiguration();
	/**	
		 Return the protocol to use in order to handle the given <code>url</code>
		 It's usually the same, except that FTP, when handled by a proxy,
		 needs an HTTP ioslave.
			 When a proxy is to be used, proxy contains the URL for the proxy.
			@param url the url to check
			@param proxy the URL of the proxy to use
				@return the slave protocol (e.g. 'http'), can be null if unknown
   
		@short    Return the protocol to use in order to handle the given <code>url</code>  It's usually the same, except that FTP, when handled by a proxy,  needs an HTTP ioslave.
	*/
	public static native String slaveProtocol(KURL url, StringBuffer proxy);
	/**	
			 (Shared with SlaveConfig)
		   		@short
	*/
	public static native KConfig config();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
