/***************************************************************************
                            HTMLButtonElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLBUTTONELEMENT_H
#define HTMLBUTTONELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Push button. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html edef]-BUTTON">
 BUTTON element definition </a> in HTML 4.0.

 
 @short 
 Push button.
*/
@class HTMLFormElement; 

@interface HTMLButtonElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
- (HTMLFormElement*) form;

/** 
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) accessKey;

/** 
 see @ref accessKey
     
*/
- setAccessKey: (NSString *)arg1;

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) disabled;

/** 
 see @ref disabled
     
*/
- setDisabled: (BOOL)arg1;

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-name-BUTTON">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
- (long) tabIndex;

/** 
 see @ref tabIndex
     
*/
- setTabIndex: (long)arg1;

/** 
 The type of button. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-type-BUTTON">
 type attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) type;

/** 
 The current form control value. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-value-BUTTON">
 value attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) value;

/** 
 see @ref value
     
*/
- setValue: (NSString *)arg1;
@end

#endif
