/***************************************************************************
                            HTMLIFrameElement.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLIFRAMEELEMENT_H
#define HTMLIFRAMEELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Inline subwindows. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html edef]-IFRAME">
 IFRAME element definition </a> in HTML 4.0.

 
 @short 
 Inline subwindows.
*/

@class DOMDocument;

@interface HTMLIFrameElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Aligns this object (vertically or horizontally) with respect to
 its surrounding text. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-align-IMG">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Request frame borders. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-frameborder">
 frameborder attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) frameBorder;

/** 
 see @ref frameBorder
     
*/
- setFrameBorder: (NSString *)arg1;

/** 
 Frame height. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-height-IFRAME">
 height attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) height;

/** 
 see @ref height
     
*/
- setHeight: (NSString *)arg1;

/** 
 URI designating a long description of this image or frame. See
 the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-longdesc-IFRAME">
 longdesc attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) longDesc;

/** 
 see @ref longDesc
     
*/
- setLongDesc: (NSString *)arg1;

/** 
 Frame margin height, in pixels. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-marginheight">
 marginheight attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) marginHeight;

/** 
 see @ref marginHeight
     
*/
- setMarginHeight: (NSString *)arg1;

/** 
 Frame margin width, in pixels. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-marginwidth">
 marginwidth attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) marginWidth;

/** 
 see @ref marginWidth
     
*/
- setMarginWidth: (NSString *)arg1;

/** 
 The frame name (object of the <code> target </code> attribute).
 See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-name-IFRAME">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 Specify whether or not the frame should have scrollbars. See
 the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-scrolling">
 scrolling attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) scrolling;

/** 
 see @ref scrolling
     
*/
- setScrolling: (NSString *)arg1;

/** 
 A URI designating the initial frame contents. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-src-FRAME">
 src attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) src;

/** 
 see @ref src
     
*/
- setSrc: (NSString *)arg1;

/** 
 Frame width. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-width-IFRAME">
 width attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) width;

/** 
 see @ref width
     
*/
- setWidth: (NSString *)arg1;

/** 
 Introduced in DOM Level 2

 Returns the document this iframe contains, if there is any and
 it is available, a Null document otherwise. The attribute is
 read-only.

*/
- (DOMDocument*) contentDocument;
@end

#endif
